/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.fishing;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.datatypes.treasure.Treasure;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingTreasureEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerShakeEvent;
import com.gmail.nossr50.events.skills.secondaryabilities.SecondaryAbilityWeightedActivationCheckEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.KrakenAttackTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.Wool;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public class FishingManager
extends SkillManager {
    private final long FISHING_COOLDOWN_SECONDS = 1000L;
    private int fishingTries = 0;
    private long fishingTimestamp = 0L;
    private Location fishingTarget;
    private Item fishingCatch;
    private Location hookLocation;

    public FishingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.FISHING);
    }

    public boolean canShake(Entity target) {
        return target instanceof LivingEntity && this.getSkillLevel() >= Fishing.Tier.ONE.getLevel() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.SHAKE);
    }

    public boolean canMasterAngler() {
        return this.getSkillLevel() >= AdvancedConfig.getInstance().getMasterAnglerUnlockLevel() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.MASTER_ANGLER);
    }

    public boolean unleashTheKraken() {
        return this.unleashTheKraken(true);
    }

    private boolean unleashTheKraken(boolean forceSpawn) {
        if (!(forceSpawn || this.fishingTries >= AdvancedConfig.getInstance().getKrakenTriesBeforeRelease() && this.fishingTries > Misc.getRandom().nextInt(200))) {
            return false;
        }
        Player player = this.getPlayer();
        World world = player.getWorld();
        player.setPlayerWeather(WeatherType.DOWNFALL);
        Entity vehicle = player.getVehicle();
        if (vehicle != null && vehicle.getType() == EntityType.BOAT) {
            vehicle.eject();
            vehicle.remove();
        }
        player.teleport(player.getTargetBlock((HashSet)null, 100).getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        String unleashMessage = AdvancedConfig.getInstance().getPlayerUnleashMessage();
        if (!unleashMessage.isEmpty()) {
            player.sendMessage(unleashMessage);
        }
        Location location = player.getLocation();
        boolean globalEffectsEnabled = AdvancedConfig.getInstance().getKrakenGlobalEffectsEnabled();
        if (globalEffectsEnabled) {
            world.strikeLightningEffect(location);
            world.strikeLightningEffect(location);
            world.strikeLightningEffect(location);
            world.playSound(location, Sound.GHAST_SCREAM, 1.0f, Misc.getGhastPitch());
            mcMMO.p.getServer().broadcastMessage(ChatColor.RED + AdvancedConfig.getInstance().getServerUnleashMessage().replace("(PLAYER)", player.getDisplayName()));
        } else {
            world.createExplosion(location.getX(), location.getY(), location.getZ(), 0.0f, false, false);
            world.createExplosion(location.getX(), location.getY(), location.getZ(), 0.0f, false, false);
            world.createExplosion(location.getX(), location.getY(), location.getZ(), 0.0f, false, false);
            player.playSound(location, Sound.GHAST_SCREAM, 1.0f, Misc.getGhastPitch());
        }
        if (player.getItemInHand().getType() == Material.FISHING_ROD) {
            player.setItemInHand(null);
        }
        LivingEntity kraken = (LivingEntity)world.spawnEntity(player.getEyeLocation(), Misc.getRandom().nextInt(100) == 0 ? EntityType.CHICKEN : EntityType.SQUID);
        kraken.setCustomName(AdvancedConfig.getInstance().getKrakenName());
        if (!kraken.isValid()) {
            int attackInterval = AdvancedConfig.getInstance().getKrakenAttackInterval() * 20;
            new KrakenAttackTask(kraken, player, player.getLocation()).runTaskTimer((Plugin)mcMMO.p, attackInterval, attackInterval);
            if (!forceSpawn) {
                this.fishingTries = 0;
            }
            return true;
        }
        kraken.setMaxHealth(AdvancedConfig.getInstance().getKrakenHealth());
        kraken.setHealth(kraken.getMaxHealth());
        int attackInterval = AdvancedConfig.getInstance().getKrakenAttackInterval() * 20;
        new KrakenAttackTask(kraken, player).runTaskTimer((Plugin)mcMMO.p, attackInterval, attackInterval);
        if (!forceSpawn) {
            this.fishingTries = 0;
        }
        return true;
    }

    public boolean exploitPrevention() {
        if (!AdvancedConfig.getInstance().getKrakenEnabled()) {
            return false;
        }
        Block targetBlock = this.getPlayer().getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
        if (!targetBlock.isLiquid()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        boolean hasFished = currentTime < this.fishingTimestamp + 1000L;
        this.fishingTries = hasFished ? this.fishingTries + 1 : Math.max(this.fishingTries - 1, 0);
        this.fishingTimestamp = currentTime;
        Location targetLocation = targetBlock.getLocation();
        boolean sameTarget = this.fishingTarget != null && this.fishingTarget.equals((Object)targetLocation);
        this.fishingTries = sameTarget ? this.fishingTries + 1 : Math.max(this.fishingTries - 1, 0);
        this.fishingTarget = targetLocation;
        return this.unleashTheKraken(false);
    }

    public boolean canIceFish(Block block) {
        if (this.getSkillLevel() < AdvancedConfig.getInstance().getIceFishingUnlockLevel()) {
            return false;
        }
        if (block.getType() != Material.ICE) {
            return false;
        }
        if (!Fishing.iceFishingBiomes.contains(block.getBiome()) && block.getRelative(BlockFace.DOWN, 3).getType() != Material.STATIONARY_WATER) {
            return false;
        }
        Player player = this.getPlayer();
        if (!Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.ICE_FISHING)) {
            return false;
        }
        return EventUtils.simulateBlockBreak(block, player, false);
    }

    public int getLootTier() {
        int skillLevel = this.getSkillLevel();
        for (Fishing.Tier tier : Fishing.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.toNumerical();
        }
        return 0;
    }

    public double getShakeProbability() {
        int skillLevel = this.getSkillLevel();
        for (Fishing.Tier tier : Fishing.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getShakeChance();
        }
        return 0.0;
    }

    public int handleFishermanDiet(int rankChange, int eventFoodLevel) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), this.skill, eventFoodLevel, Fishing.fishermansDietRankLevel1, Fishing.fishermansDietMaxLevel, rankChange);
    }

    public void iceFishing(Fish hook, Block block) {
        block.setType(Material.STATIONARY_WATER);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Block relative = block.getRelative(x, 0, z);
                if (relative.getType() != Material.ICE) continue;
                relative.setType(Material.STATIONARY_WATER);
            }
        }
        EventUtils.callFakeFishEvent(this.getPlayer(), hook);
    }

    public void masterAngler(Fish hook) {
        Player player = this.getPlayer();
        Location location = hook.getLocation();
        double biteChance = hook.getBiteChance();
        this.hookLocation = location;
        if (Fishing.masterAnglerBiomes.contains(location.getBlock().getBiome())) {
            biteChance *= AdvancedConfig.getInstance().getMasterAnglerBiomeModifier();
        }
        if (player.isInsideVehicle() && player.getVehicle().getType() == EntityType.BOAT) {
            biteChance *= AdvancedConfig.getInstance().getMasterAnglerBoatModifier();
        }
        hook.setBiteChance(Math.min(biteChance, 1.0));
    }

    public void handleFishing(Item fishingCatch) {
        this.fishingCatch = fishingCatch;
        int fishXp = ExperienceConfig.getInstance().getFishXp(fishingCatch.getItemStack().getData());
        int treasureXp = 0;
        Player player = this.getPlayer();
        Treasure treasure = null;
        if (Config.getInstance().getFishingDropsEnabled() && Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FISHING_TREASURE_HUNTER)) {
            treasure = this.getFishingTreasure();
            this.fishingCatch = null;
        }
        if (treasure != null) {
            McMMOPlayerFishingTreasureEvent event;
            ItemStack treasureDrop = treasure.getDrop().clone();
            Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.MAGIC_HUNTER) && ItemUtils.isEnchantable(treasureDrop)) {
                enchants = this.handleMagicHunter(treasureDrop);
            }
            if (!(event = EventUtils.callFishingTreasureEvent(player, treasureDrop, treasure.getXp(), enchants)).isCancelled()) {
                treasureDrop = event.getTreasure();
                treasureXp = event.getXp();
            } else {
                treasureDrop = null;
                treasureXp = 0;
            }
            if (treasureDrop != null) {
                boolean enchanted = false;
                if (!enchants.isEmpty()) {
                    treasureDrop.addUnsafeEnchantments(enchants);
                    enchanted = true;
                }
                if (enchanted) {
                    player.sendMessage(LocaleLoader.getString("Fishing.Ability.TH.MagicFound"));
                }
                if (Config.getInstance().getFishingExtraFish()) {
                    Misc.dropItem(player.getEyeLocation(), fishingCatch.getItemStack());
                }
                fishingCatch.setItemStack(treasureDrop);
            }
        }
        this.applyXpGain(fishXp + treasureXp, XPGainReason.PVE);
    }

    public int handleVanillaXpBoost(int experience) {
        return experience * this.getVanillaXpMultiplier();
    }

    public Location getHookLocation() {
        return this.hookLocation;
    }

    public void shakeCheck(LivingEntity target) {
        --this.fishingTries;
        SecondaryAbilityWeightedActivationCheckEvent activationEvent = new SecondaryAbilityWeightedActivationCheckEvent(this.getPlayer(), SecondaryAbility.SHAKE, this.getShakeProbability() / (double)this.activationChance);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)activationEvent);
        if (activationEvent.getChance() * (double)this.activationChance > (double)Misc.getRandom().nextInt(this.activationChance)) {
            List<ShakeTreasure> possibleDrops = Fishing.findPossibleDrops(target);
            if (possibleDrops == null || possibleDrops.isEmpty()) {
                return;
            }
            ItemStack drop = Fishing.chooseDrop(possibleDrops);
            if (drop == null) {
                return;
            }
            block0 : switch (target.getType()) {
                case PLAYER: {
                    Player targetPlayer = (Player)target;
                    switch (drop.getType()) {
                        case SKULL_ITEM: {
                            drop.setDurability((short)3);
                            SkullMeta skullMeta = (SkullMeta)drop.getItemMeta();
                            skullMeta.setOwner(targetPlayer.getName());
                            drop.setItemMeta((ItemMeta)skullMeta);
                            break;
                        }
                        case BED_BLOCK: {
                            if (!TreasureConfig.getInstance().getInventoryStealEnabled()) break;
                            PlayerInventory inventory = targetPlayer.getInventory();
                            int length = inventory.getContents().length;
                            int slot = Misc.getRandom().nextInt(length);
                            drop = inventory.getItem(slot);
                            if (drop == null) break;
                            if (TreasureConfig.getInstance().getInventoryStealStacks()) {
                                inventory.setItem(slot, null);
                            } else {
                                inventory.setItem(slot, drop.getAmount() > 1 ? new ItemStack(drop.getType(), drop.getAmount() - 1) : null);
                                drop.setAmount(1);
                            }
                            targetPlayer.updateInventory();
                            break;
                        }
                    }
                    break;
                }
                case SHEEP: {
                    Sheep sheep = (Sheep)target;
                    if (drop.getType() != Material.WOOL) break;
                    if (sheep.isSheared()) {
                        return;
                    }
                    drop = new Wool(sheep.getColor()).toItemStack(drop.getAmount());
                    sheep.setSheared(true);
                    break;
                }
                case SKELETON: {
                    if (((Skeleton)target).getSkeletonType() != Skeleton.SkeletonType.WITHER) break;
                    switch (drop.getType()) {
                        case SKULL_ITEM: {
                            drop.setDurability((short)1);
                            break block0;
                        }
                        case ARROW: {
                            drop.setType(Material.COAL);
                            break block0;
                        }
                    }
                    break;
                }
            }
            McMMOPlayerShakeEvent shakeEvent = new McMMOPlayerShakeEvent(this.getPlayer(), drop);
            drop = shakeEvent.getDrop();
            if (shakeEvent.isCancelled() || drop == null) {
                return;
            }
            Misc.dropItem(target.getLocation(), drop);
            CombatUtils.dealDamage(target, Math.max(target.getMaxHealth() / 4.0, 1.0), (LivingEntity)this.getPlayer());
            this.applyXpGain(ExperienceConfig.getInstance().getFishingShakeXP(), XPGainReason.PVE);
        }
    }

    private FishingTreasure getFishingTreasure() {
        double diceRoll = Misc.getRandom().nextDouble() * 100.0;
        diceRoll -= (double)this.getPlayer().getItemInHand().getEnchantmentLevel(Enchantment.LUCK);
        Treasure treasure = null;
        for (Rarity rarity : Rarity.values()) {
            double dropRate = TreasureConfig.getInstance().getItemDropRate(this.getLootTier(), rarity);
            if (diceRoll <= dropRate) {
                if (rarity == Rarity.TRAP) {
                    this.handleTraps();
                    break;
                }
                List<FishingTreasure> fishingTreasures = TreasureConfig.getInstance().fishingRewards.get((Object)rarity);
                if (fishingTreasures.isEmpty()) {
                    return null;
                }
                treasure = fishingTreasures.get(Misc.getRandom().nextInt(fishingTreasures.size()));
                break;
            }
            diceRoll -= dropRate;
        }
        if (treasure == null) {
            return null;
        }
        ItemStack treasureDrop = treasure.getDrop().clone();
        short maxDurability = treasureDrop.getType().getMaxDurability();
        if (maxDurability > 0) {
            treasureDrop.setDurability((short)Misc.getRandom().nextInt(maxDurability));
        }
        if (treasureDrop.getAmount() > 1) {
            treasureDrop.setAmount(Misc.getRandom().nextInt(treasureDrop.getAmount()) + 1);
        }
        treasure.setDrop(treasureDrop);
        return treasure;
    }

    private void handleTraps() {
        Player player = this.getPlayer();
        if (Permissions.trapsBypass((Permissible)player)) {
            return;
        }
        if (Misc.getRandom().nextBoolean()) {
            player.sendMessage(LocaleLoader.getString("Fishing.Ability.TH.Boom"));
            TNTPrimed tnt = (TNTPrimed)player.getWorld().spawnEntity(this.fishingCatch.getLocation(), EntityType.PRIMED_TNT);
            this.fishingCatch.setPassenger((Entity)tnt);
            Vector velocity = this.fishingCatch.getVelocity();
            double magnitude = velocity.length();
            this.fishingCatch.setVelocity(velocity.multiply((magnitude + 1.0) / magnitude));
            tnt.setMetadata("mcMMO: Safe TNT", (MetadataValue)mcMMO.metadataValue);
            tnt.setFuseTicks(60);
        } else {
            player.sendMessage(LocaleLoader.getString("Fishing.Ability.TH.Poison"));
            ThrownPotion thrownPotion = (ThrownPotion)player.getWorld().spawn(this.fishingCatch.getLocation(), ThrownPotion.class);
            thrownPotion.setItem(new Potion(PotionType.POISON).splash().toItemStack(1));
            this.fishingCatch.setPassenger((Entity)thrownPotion);
        }
    }

    private Map<Enchantment, Integer> handleMagicHunter(ItemStack treasureDrop) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        List<EnchantmentTreasure> fishingEnchantments = null;
        double diceRoll = Misc.getRandom().nextDouble() * 100.0;
        for (Rarity rarity : Rarity.values()) {
            if (rarity == Rarity.TRAP || rarity == Rarity.RECORD) continue;
            double dropRate = TreasureConfig.getInstance().getEnchantmentDropRate(this.getLootTier(), rarity);
            if (diceRoll <= dropRate) {
                fishingEnchantments = TreasureConfig.getInstance().fishingEnchantments.get((Object)rarity);
                break;
            }
            diceRoll -= dropRate;
        }
        if (fishingEnchantments == null) {
            return enchants;
        }
        List<Enchantment> validEnchantments = this.getPossibleEnchantments(treasureDrop);
        ArrayList<EnchantmentTreasure> possibleEnchants = new ArrayList<EnchantmentTreasure>();
        for (EnchantmentTreasure enchantmentTreasure : fishingEnchantments) {
            if (!validEnchantments.contains(enchantmentTreasure.getEnchantment())) continue;
            possibleEnchants.add(enchantmentTreasure);
        }
        if (possibleEnchants.isEmpty()) {
            return enchants;
        }
        Collections.shuffle(possibleEnchants, Misc.getRandom());
        int specificChance = 1;
        for (EnchantmentTreasure enchantmentTreasure : possibleEnchants) {
            Enchantment possibleEnchantment = enchantmentTreasure.getEnchantment();
            if (treasureDrop.getItemMeta().hasConflictingEnchant(possibleEnchantment) || Misc.getRandom().nextInt(specificChance) != 0) continue;
            enchants.put(possibleEnchantment, enchantmentTreasure.getLevel());
            specificChance *= 2;
        }
        return enchants;
    }

    private List<Enchantment> getPossibleEnchantments(ItemStack treasureDrop) {
        Material dropType = treasureDrop.getType();
        if (Fishing.ENCHANTABLE_CACHE.containsKey(dropType)) {
            return Fishing.ENCHANTABLE_CACHE.get(dropType);
        }
        ArrayList<Enchantment> possibleEnchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : Enchantment.values()) {
            if (!enchantment.canEnchantItem(treasureDrop)) continue;
            possibleEnchantments.add(enchantment);
        }
        Fishing.ENCHANTABLE_CACHE.put(dropType, possibleEnchantments);
        return possibleEnchantments;
    }

    private int getVanillaXpMultiplier() {
        int skillLevel = this.getSkillLevel();
        for (Fishing.Tier tier : Fishing.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getVanillaXPBoostModifier();
        }
        return 0;
    }
}

