/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.archery;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.skills.archery.TrackedEntity;
import com.gmail.nossr50.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class Archery {
    private static List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();
    public static int skillShotIncreaseLevel = AdvancedConfig.getInstance().getSkillShotIncreaseLevel();
    public static double skillShotIncreasePercentage = AdvancedConfig.getInstance().getSkillShotIncreasePercentage();
    public static double skillShotMaxBonusPercentage = AdvancedConfig.getInstance().getSkillShotBonusMax();
    public static double skillShotMaxBonusDamage = AdvancedConfig.getInstance().getSkillShotDamageMax();
    public static double dazeBonusDamage = AdvancedConfig.getInstance().getDazeBonusDamage();
    public static final double DISTANCE_XP_MULTIPLIER = ExperienceConfig.getInstance().getArcheryDistanceMultiplier();

    protected static void incrementTrackerValue(LivingEntity livingEntity) {
        for (TrackedEntity trackedEntity : trackedEntities) {
            if (trackedEntity.getLivingEntity().getEntityId() != livingEntity.getEntityId()) continue;
            trackedEntity.incrementArrowCount();
            return;
        }
        Archery.addToTracker(livingEntity);
    }

    protected static void addToTracker(LivingEntity livingEntity) {
        TrackedEntity trackedEntity = new TrackedEntity(livingEntity);
        trackedEntity.incrementArrowCount();
        trackedEntities.add(trackedEntity);
    }

    protected static void removeFromTracker(TrackedEntity trackedEntity) {
        trackedEntities.remove((Object)trackedEntity);
    }

    public static void arrowRetrievalCheck(LivingEntity livingEntity) {
        Iterator<TrackedEntity> entityIterator = trackedEntities.iterator();
        while (entityIterator.hasNext()) {
            TrackedEntity trackedEntity = entityIterator.next();
            if (trackedEntity.getID() != livingEntity.getUniqueId()) continue;
            Misc.dropItems(livingEntity.getLocation(), new ItemStack(Material.ARROW), trackedEntity.getArrowCount());
            entityIterator.remove();
            return;
        }
    }
}

