/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.util.Misc;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class KrakenAttackTask
extends BukkitRunnable {
    private LivingEntity kraken;
    private Player player;
    private Location location;
    private final boolean GLOBAL_EFFECTS = AdvancedConfig.getInstance().getKrakenGlobalEffectsEnabled();
    private final String DEFEAT_MESSAGE = AdvancedConfig.getInstance().getPlayerDefeatMessage();
    private final String ESCAPE_MESSAGE = AdvancedConfig.getInstance().getPlayerEscapeMessage();

    public KrakenAttackTask(LivingEntity kraken2, Player player) {
        this.kraken = kraken2;
        this.player = player;
    }

    public KrakenAttackTask(LivingEntity kraken2, Player player, Location location) {
        this.kraken = kraken2;
        this.player = player;
        this.location = location;
    }

    public void run() {
        if (this.location != null) {
            Location playerLocation = this.player.getLocation();
            if (this.player.isValid() && playerLocation.getBlock().isLiquid()) {
                World world = this.player.getWorld();
                this.krakenAttack(playerLocation, world);
            } else {
                this.player.sendMessage(AdvancedConfig.getInstance().getPlayerEscapeMessage());
                this.player.resetPlayerWeather();
                this.cancel();
            }
            return;
        }
        if (!this.kraken.isValid()) {
            if (!this.DEFEAT_MESSAGE.isEmpty()) {
                this.player.sendMessage(this.DEFEAT_MESSAGE);
            }
            this.player.resetPlayerWeather();
            this.cancel();
        }
        if (this.player.isValid()) {
            Location location = this.player.getLocation();
            if (!location.getBlock().isLiquid() && AdvancedConfig.getInstance().getKrakenEscapeAllowed()) {
                if (!this.ESCAPE_MESSAGE.isEmpty()) {
                    this.player.sendMessage(AdvancedConfig.getInstance().getPlayerEscapeMessage());
                }
                this.kraken.remove();
                this.player.resetPlayerWeather();
                this.cancel();
                return;
            }
            World world = this.player.getWorld();
            this.kraken.teleport((Entity)this.player);
            this.krakenAttack(location, world);
        } else {
            this.kraken.remove();
            this.cancel();
        }
    }

    private void krakenAttack(Location playerLocation, World world) {
        this.player.damage(AdvancedConfig.getInstance().getKrakenAttackDamage(), (Entity)this.kraken);
        if (this.GLOBAL_EFFECTS) {
            world.playSound(playerLocation, Sound.GHAST_SCREAM, 1.0f, Misc.getGhastPitch());
            world.strikeLightningEffect(playerLocation);
        } else {
            this.player.playSound(playerLocation, Sound.GHAST_SCREAM, 1.0f, Misc.getGhastPitch());
            world.createExplosion(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ(), 0.0f, false, false);
        }
    }
}

