/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class BleedTimerTask
extends BukkitRunnable {
    private static final int MAX_BLEED_TICKS = 10;
    private static Map<LivingEntity, Integer> bleedList = new HashMap<LivingEntity, Integer>();

    public void run() {
        Iterator<Map.Entry<LivingEntity, Integer>> bleedIterator = bleedList.entrySet().iterator();
        while (bleedIterator.hasNext()) {
            double damage;
            Map.Entry<LivingEntity, Integer> entry = bleedIterator.next();
            LivingEntity entity = entry.getKey();
            if (entry.getValue() <= 0 || !entity.isValid()) {
                bleedIterator.remove();
                continue;
            }
            if (entity instanceof Player) {
                damage = AdvancedConfig.getInstance().getBleedDamagePlayer();
                Player player = (Player)entity;
                if (!player.isOnline()) continue;
                if (player.getHealth() - damage > 0.0) {
                    CombatUtils.dealDamage((LivingEntity)player, damage);
                    ParticleEffectUtils.playBleedEffect(entity);
                }
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                player.sendMessage(LocaleLoader.getString("Swords.Combat.Bleeding.Stopped"));
                continue;
            }
            damage = AdvancedConfig.getInstance().getBleedDamageMobs();
            if (entity.getHealth() - damage > 0.0) {
                entry.setValue(entry.getValue() - 1);
            } else {
                bleedIterator.remove();
            }
            CombatUtils.dealDamage(entity, damage);
            ParticleEffectUtils.playBleedEffect(entity);
        }
    }

    public static void bleedOut(LivingEntity entity) {
        if (bleedList.containsKey(entity)) {
            CombatUtils.dealDamage(entity, bleedList.get(entity) * 2);
            bleedList.remove(entity);
        }
    }

    public static void remove(LivingEntity entity) {
        if (bleedList.containsKey(entity)) {
            bleedList.remove(entity);
        }
    }

    public static void add(LivingEntity entity, int ticks) {
        int newTicks = ticks;
        if (bleedList.containsKey(entity)) {
            bleedList.put(entity, Math.min(newTicks += bleedList.get(entity).intValue(), 10));
        } else {
            bleedList.put(entity, Math.min(newTicks, 10));
        }
    }

    public static boolean isBleeding(LivingEntity entity) {
        return bleedList.containsKey(entity);
    }
}

