/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.locale.LocaleLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PartyChatTask
extends BukkitRunnable {
    private Plugin plugin;
    private Party party;
    private String senderName;
    private String displayName;
    private String message;

    public PartyChatTask(Plugin plugin, Party party, String senderName, String displayName, String message) {
        this.plugin = plugin;
        this.party = party;
        this.senderName = senderName;
        this.displayName = displayName;
        this.message = message;
    }

    public void run() {
        if (Config.getInstance().getPartyChatColorLeaderName() && this.senderName.equalsIgnoreCase(this.party.getLeader().getPlayerName())) {
            this.message = this.message.replaceFirst(Pattern.quote(this.displayName), ChatColor.GOLD + Matcher.quoteReplacement(this.displayName) + ChatColor.RESET);
        }
        for (Player member : this.party.getOnlineMembers()) {
            member.sendMessage(this.message);
        }
        if (this.party.getAlly() != null) {
            for (Player member : this.party.getAlly().getOnlineMembers()) {
                String allyPrefix = LocaleLoader.formatString(Config.getInstance().getPartyChatPrefixAlly(), new Object[0]);
                member.sendMessage(allyPrefix + this.message);
            }
        }
        this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.stripColor((String)("[mcMMO] [P]<" + this.party.getName() + ">" + this.message)));
    }
}

