/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.database;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.scheduler.BukkitRunnable;

public class FormulaConversionTask
extends BukkitRunnable {
    private CommandSender sender;
    private FormulaType formulaType;

    public FormulaConversionTask(CommandSender sender, FormulaType formulaType) {
        this.sender = sender;
        this.formulaType = formulaType;
    }

    public void run() {
        int convertedUsers = 0;
        long startMillis = System.currentTimeMillis();
        for (String playerName : mcMMO.getDatabaseManager().getStoredUsers()) {
            PlayerProfile profile;
            McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(playerName);
            if (mcMMOPlayer == null) {
                profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName, false);
                if (!profile.isLoaded()) {
                    mcMMO.p.debug("Profile not loaded.");
                    continue;
                }
                this.editValues(profile);
                profile.scheduleAsyncSave();
            } else {
                profile = mcMMOPlayer.getProfile();
                this.editValues(profile);
            }
            Misc.printProgress(++convertedUsers, 200, startMillis);
        }
        mcMMO.getFormulaManager().setPreviousFormulaType(this.formulaType);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Experience.Finish", this.formulaType.toString()));
    }

    private void editValues(PlayerProfile profile) {
        mcMMO.p.debug("========================================================================");
        mcMMO.p.debug("Conversion report for " + profile.getPlayerName() + ":");
        for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
            int oldLevel = profile.getSkillLevel(skillType);
            int oldXPLevel = profile.getSkillXpLevel(skillType);
            int totalOldXP = mcMMO.getFormulaManager().calculateTotalExperience(oldLevel, oldXPLevel);
            if (totalOldXP == 0) continue;
            int[] newExperienceValues = mcMMO.getFormulaManager().calculateNewLevel(skillType, (int)Math.floor((double)totalOldXP / ExperienceConfig.getInstance().getExpModifier()), this.formulaType);
            int newLevel = newExperienceValues[0];
            int newXPlevel = newExperienceValues[1];
            mcMMO.p.debug("  Skill: " + skillType.toString());
            mcMMO.p.debug("    OLD:");
            mcMMO.p.debug("      Level: " + oldLevel);
            mcMMO.p.debug("      XP " + oldXPLevel);
            mcMMO.p.debug("      Total XP " + totalOldXP);
            mcMMO.p.debug("    NEW:");
            mcMMO.p.debug("      Level " + newLevel);
            mcMMO.p.debug("      XP " + newXPlevel);
            mcMMO.p.debug("------------------------------------------------------------------------");
            profile.modifySkill(skillType, newLevel);
            profile.setSkillXpLevel(skillType, newXPlevel);
        }
    }
}

