/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MctopCommandDisplayTask
extends BukkitRunnable {
    private final List<PlayerStat> userStats;
    private final CommandSender sender;
    private final SkillType skill;
    private final int page;
    private final boolean useBoard;
    private final boolean useChat;

    MctopCommandDisplayTask(List<PlayerStat> userStats, int page, SkillType skill, CommandSender sender, boolean useBoard, boolean useChat) {
        this.userStats = userStats;
        this.page = page;
        this.skill = skill;
        this.sender = sender;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    public void run() {
        if (this.useBoard) {
            this.displayBoard();
        }
        if (this.useChat) {
            this.displayChat();
        }
        if (this.sender instanceof Player) {
            ((Player)this.sender).removeMetadata("mcMMO: Processing Database Command", (Plugin)mcMMO.p);
        }
        this.sender.sendMessage(LocaleLoader.getString("Commands.mctop.Tip"));
    }

    private void displayChat() {
        if (this.skill == null) {
            this.sender.sendMessage(LocaleLoader.getString("Commands.PowerLevel.Leaderboard"));
        } else {
            this.sender.sendMessage(LocaleLoader.getString("Commands.Skill.Leaderboard", this.skill.getName()));
        }
        int place = this.page * 10 - 9;
        for (PlayerStat stat : this.userStats) {
            this.sender.sendMessage(String.format("%2d. %s%s - %s%s", place, ChatColor.GREEN, stat.name, ChatColor.WHITE, stat.statVal));
            ++place;
        }
    }

    private void displayBoard() {
        if (this.skill == null) {
            ScoreboardManager.showTopPowerScoreboard((Player)this.sender, this.page, this.userStats);
        } else {
            ScoreboardManager.showTopScoreboard((Player)this.sender, this.skill, this.page, this.userStats);
        }
    }
}

