/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class McrankCommandDisplayTask
extends BukkitRunnable {
    private final Map<SkillType, Integer> skills;
    private final CommandSender sender;
    private final String playerName;
    private final boolean useBoard;
    private final boolean useChat;

    McrankCommandDisplayTask(Map<SkillType, Integer> skills, CommandSender sender, String playerName, boolean useBoard, boolean useChat) {
        this.skills = skills;
        this.sender = sender;
        this.playerName = playerName;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    public void run() {
        if (this.useBoard) {
            this.displayBoard();
        }
        if (this.useChat) {
            this.displayChat();
        }
        ((Player)this.sender).removeMetadata("mcMMO: Processing Database Command", (Plugin)mcMMO.p);
    }

    private void displayChat() {
        Integer rank;
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Heading"));
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Player", this.playerName));
        for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
            if (!skill.getPermissions(player)) continue;
            rank = this.skills.get((Object)skill);
            this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Skill", skill.getName(), rank == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : rank));
        }
        rank = this.skills.get(null);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Overall", rank == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : rank));
    }

    public void displayBoard() {
        if (this.sender.getName().equalsIgnoreCase(this.playerName)) {
            ScoreboardManager.showPlayerRankScoreboard((Player)this.sender, this.skills);
        } else {
            ScoreboardManager.showPlayerRankScoreboardOthers((Player)this.sender, this.playerName, this.skills);
        }
    }
}

