/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.events.party.McMMOPartyAllianceChangeEvent;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class PartyManager {
    private static String partiesFilePath = mcMMO.getFlatFileDirectory() + "parties.yml";
    private static List<Party> parties = new ArrayList<Party>();
    private static File partyFile = new File(partiesFilePath);

    private PartyManager() {
    }

    public static boolean checkPartyExistence(Player player, String partyName) {
        if (PartyManager.getParty(partyName) == null) {
            return false;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.AlreadyExists", partyName));
        return true;
    }

    public static boolean changeOrJoinParty(McMMOPlayer mcMMOPlayer, String newPartyName) {
        Player player = mcMMOPlayer.getPlayer();
        if (mcMMOPlayer.inParty()) {
            Party oldParty = mcMMOPlayer.getParty();
            if (!PartyManager.handlePartyChangeEvent(player, oldParty.getName(), newPartyName, McMMOPartyChangeEvent.EventReason.CHANGED_PARTIES)) {
                return false;
            }
            PartyManager.removeFromParty(mcMMOPlayer);
        } else if (!PartyManager.handlePartyChangeEvent(player, null, newPartyName, McMMOPartyChangeEvent.EventReason.JOINED_PARTY)) {
            return false;
        }
        return true;
    }

    public static boolean inSameParty(Player firstPlayer, Player secondPlayer) {
        Party firstParty = UserManager.getPlayer(firstPlayer).getParty();
        Party secondParty = UserManager.getPlayer(secondPlayer).getParty();
        if (firstParty == null || secondParty == null) {
            return false;
        }
        return firstParty.equals(secondParty);
    }

    public static boolean areAllies(Player firstPlayer, Player secondPlayer) {
        Party firstParty = UserManager.getPlayer(firstPlayer).getParty();
        Party secondParty = UserManager.getPlayer(secondPlayer).getParty();
        if (firstParty == null || secondParty == null || firstParty.getAlly() == null || secondParty.getAlly() == null) {
            return false;
        }
        return firstParty.equals(secondParty.getAlly()) && secondParty.equals(firstParty.getAlly());
    }

    public static List<Player> getNearMembers(McMMOPlayer mcMMOPlayer) {
        ArrayList<Player> nearMembers = new ArrayList<Player>();
        Party party = mcMMOPlayer.getParty();
        if (party != null) {
            Player player = mcMMOPlayer.getPlayer();
            double range = Config.getInstance().getPartyShareRange();
            for (Player member : party.getOnlineMembers()) {
                if (player.equals(member) || !member.isValid() || !Misc.isNear(player.getLocation(), member.getLocation(), range)) continue;
                nearMembers.add(member);
            }
        }
        return nearMembers;
    }

    public static LinkedHashMap<UUID, String> getAllMembers(Player player) {
        Party party = PartyManager.getParty(player);
        return party == null ? new LinkedHashMap<UUID, String>() : party.getMembers();
    }

    public static List<Player> getOnlineMembers(String partyName) {
        return PartyManager.getOnlineMembers(PartyManager.getParty(partyName));
    }

    public static List<Player> getOnlineMembers(Player player) {
        return PartyManager.getOnlineMembers(PartyManager.getParty(player));
    }

    private static List<Player> getOnlineMembers(Party party) {
        return party == null ? new ArrayList() : party.getOnlineMembers();
    }

    public static Party getParty(String partyName) {
        for (Party party : parties) {
            if (!party.getName().equalsIgnoreCase(partyName)) continue;
            return party;
        }
        return null;
    }

    @Deprecated
    public static Party getPlayerParty(String playerName) {
        for (Party party : parties) {
            if (!party.getMembers().keySet().contains(playerName)) continue;
            return party;
        }
        return null;
    }

    public static Party getPlayerParty(String playerName, UUID uuid) {
        for (Party party : parties) {
            LinkedHashMap<UUID, String> members = party.getMembers();
            if (!members.keySet().contains(uuid) && !members.values().contains(playerName)) continue;
            if (members.get(uuid) == null || !members.get(uuid).equals(playerName)) {
                members.put(uuid, playerName);
            }
            return party;
        }
        return null;
    }

    public static Party getParty(Player player) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        return mcMMOPlayer.getParty();
    }

    public static List<Party> getParties() {
        return parties;
    }

    public static void removeFromParty(OfflinePlayer player, Party party) {
        LinkedHashMap<UUID, String> members = party.getMembers();
        String playerName = player.getName();
        members.remove(player.getUniqueId());
        if (player.isOnline()) {
            party.getOnlineMembers().remove(player.getPlayer());
        }
        if (members.isEmpty()) {
            parties.remove(party);
        } else {
            if (party.getLeader().getUniqueId().equals(player.getUniqueId())) {
                PartyManager.setPartyLeader(members.keySet().iterator().next(), party);
            }
            PartyManager.informPartyMembersQuit(party, playerName);
        }
    }

    public static void removeFromParty(McMMOPlayer mcMMOPlayer) {
        PartyManager.removeFromParty((OfflinePlayer)mcMMOPlayer.getPlayer(), mcMMOPlayer.getParty());
        PartyManager.processPartyLeaving(mcMMOPlayer);
    }

    public static void disbandParty(Party party) {
        for (Player member : party.getOnlineMembers()) {
            PartyManager.processPartyLeaving(UserManager.getPlayer(member));
        }
        if (party.getAlly() != null) {
            party.getAlly().setAlly(null);
        }
        parties.remove(party);
    }

    public static void createParty(McMMOPlayer mcMMOPlayer, String partyName, String password) {
        Player player = mcMMOPlayer.getPlayer();
        Party party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), partyName.replace(".", ""), password);
        if (password != null) {
            player.sendMessage(LocaleLoader.getString("Party.Password.Set", password));
        }
        parties.add(party);
        player.sendMessage(LocaleLoader.getString("Commands.Party.Create", party.getName()));
        PartyManager.addToParty(mcMMOPlayer, party);
    }

    public static boolean checkPartyPassword(Player player, Party party, String password) {
        if (party.isLocked()) {
            String partyPassword = party.getPassword();
            if (partyPassword == null) {
                player.sendMessage(LocaleLoader.getString("Party.Locked"));
                return false;
            }
            if (password == null) {
                player.sendMessage(LocaleLoader.getString("Party.Password.None"));
                return false;
            }
            if (!password.equals(partyPassword)) {
                player.sendMessage(LocaleLoader.getString("Party.Password.Incorrect"));
                return false;
            }
        }
        return true;
    }

    public static void joinInvitedParty(McMMOPlayer mcMMOPlayer) {
        Party invite = mcMMOPlayer.getPartyInvite();
        if (!parties.contains(invite)) {
            mcMMOPlayer.getPlayer().sendMessage(LocaleLoader.getString("Party.Disband"));
            return;
        }
        mcMMOPlayer.getPlayer().sendMessage(LocaleLoader.getString("Commands.Party.Invite.Accepted", invite.getName()));
        mcMMOPlayer.removePartyInvite();
        PartyManager.addToParty(mcMMOPlayer, invite);
    }

    public static void acceptAllianceInvite(McMMOPlayer mcMMOPlayer) {
        Party invite = mcMMOPlayer.getPartyAllianceInvite();
        Player player = mcMMOPlayer.getPlayer();
        if (!parties.contains(invite)) {
            player.sendMessage(LocaleLoader.getString("Party.Disband"));
            return;
        }
        if (!PartyManager.handlePartyChangeAllianceEvent(player, mcMMOPlayer.getParty().getName(), invite.getName(), McMMOPartyAllianceChangeEvent.EventReason.FORMED_ALLIANCE)) {
            return;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Invite.Accepted", invite.getName()));
        mcMMOPlayer.removePartyAllianceInvite();
        PartyManager.createAlliance(mcMMOPlayer.getParty(), invite);
    }

    public static void createAlliance(Party firstParty, Party secondParty) {
        firstParty.setAlly(secondParty);
        secondParty.setAlly(firstParty);
        for (Player member : firstParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", secondParty.getName()));
        }
        for (Player member : secondParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", firstParty.getName()));
        }
    }

    public static boolean disbandAlliance(Player player, Party firstParty, Party secondParty) {
        if (!PartyManager.handlePartyChangeAllianceEvent(player, firstParty.getName(), secondParty.getName(), McMMOPartyAllianceChangeEvent.EventReason.DISBAND_ALLIANCE)) {
            return false;
        }
        PartyManager.disbandAlliance(firstParty, secondParty);
        return true;
    }

    private static void disbandAlliance(Party firstParty, Party secondParty) {
        firstParty.setAlly(null);
        secondParty.setAlly(null);
        for (Player member : firstParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", secondParty.getName()));
        }
        for (Player member : secondParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", firstParty.getName()));
        }
    }

    public static void addToParty(McMMOPlayer mcMMOPlayer, Party party) {
        Player player = mcMMOPlayer.getPlayer();
        String playerName = player.getName();
        PartyManager.informPartyMembersJoin(party, playerName);
        mcMMOPlayer.setParty(party);
        party.getMembers().put(player.getUniqueId(), player.getName());
        party.getOnlineMembers().add(player);
    }

    public static String getPartyLeaderName(String partyName) {
        Party party = PartyManager.getParty(partyName);
        return party == null ? null : party.getLeader().getPlayerName();
    }

    public static void setPartyLeader(UUID uuid, Party party) {
        OfflinePlayer player = mcMMO.p.getServer().getOfflinePlayer(uuid);
        UUID leaderUniqueId = party.getLeader().getUniqueId();
        for (Player member : party.getOnlineMembers()) {
            UUID memberUniqueId = member.getUniqueId();
            if (memberUniqueId.equals(player.getUniqueId())) {
                member.sendMessage(LocaleLoader.getString("Party.Owner.Player"));
                continue;
            }
            if (memberUniqueId.equals(leaderUniqueId)) {
                member.sendMessage(LocaleLoader.getString("Party.Owner.NotLeader"));
                continue;
            }
            member.sendMessage(LocaleLoader.getString("Party.Owner.New", player.getName()));
        }
        party.setLeader(new PartyLeader(player.getUniqueId(), player.getName()));
    }

    public static boolean canInvite(McMMOPlayer mcMMOPlayer) {
        Party party = mcMMOPlayer.getParty();
        return !party.isLocked() || party.getLeader().getUniqueId().equals(mcMMOPlayer.getPlayer().getUniqueId());
    }

    public static void loadParties() {
        if (!partyFile.exists()) {
            return;
        }
        if (mcMMO.getUpgradeManager().shouldUpgrade(UpgradeType.ADD_UUIDS_PARTY)) {
            PartyManager.loadAndUpgradeParties();
            return;
        }
        YamlConfiguration partiesFile = YamlConfiguration.loadConfiguration((File)partyFile);
        ArrayList<Party> hasAlly = new ArrayList<Party>();
        for (String partyName : partiesFile.getConfigurationSection("").getKeys(false)) {
            Party party = new Party(partyName);
            String[] leaderSplit = partiesFile.getString(partyName + ".Leader").split("[|]");
            party.setLeader(new PartyLeader(UUID.fromString(leaderSplit[0]), leaderSplit[1]));
            party.setPassword(partiesFile.getString(partyName + ".Password"));
            party.setLocked(partiesFile.getBoolean(partyName + ".Locked"));
            party.setLevel(partiesFile.getInt(partyName + ".Level"));
            party.setXp(partiesFile.getInt(partyName + ".Xp"));
            if (partiesFile.getString(partyName + ".Ally") != null) {
                hasAlly.add(party);
            }
            party.setXpShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ExpShareMode", "NONE")));
            party.setItemShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ItemShareMode", "NONE")));
            for (ItemShareType itemShareType : ItemShareType.values()) {
                party.setSharingDrops(itemShareType, partiesFile.getBoolean(partyName + ".ItemShareType." + itemShareType.toString(), true));
            }
            LinkedHashMap<UUID, String> members = party.getMembers();
            for (String memberEntry : partiesFile.getStringList(partyName + ".Members")) {
                String[] memberSplit = memberEntry.split("[|]");
                members.put(UUID.fromString(memberSplit[0]), memberSplit[1]);
            }
            parties.add(party);
        }
        mcMMO.p.debug("Loaded (" + parties.size() + ") Parties...");
        for (Party party : hasAlly) {
            party.setAlly(PartyManager.getParty(partiesFile.getString(party.getName() + ".Ally")));
        }
    }

    public static void saveParties() {
        if (partyFile.exists() && !partyFile.delete()) {
            mcMMO.p.getLogger().warning("Could not delete party file. Party saving failed!");
            return;
        }
        YamlConfiguration partiesFile = new YamlConfiguration();
        mcMMO.p.debug("Saving Parties... (" + parties.size() + ")");
        for (Party party : parties) {
            String partyName = party.getName();
            PartyLeader leader = party.getLeader();
            partiesFile.set(partyName + ".Leader", (Object)(leader.getUniqueId().toString() + "|" + leader.getPlayerName()));
            partiesFile.set(partyName + ".Password", (Object)party.getPassword());
            partiesFile.set(partyName + ".Locked", (Object)party.isLocked());
            partiesFile.set(partyName + ".Level", (Object)party.getLevel());
            partiesFile.set(partyName + ".Xp", (Object)((int)party.getXp()));
            partiesFile.set(partyName + ".Ally", (Object)(party.getAlly() != null ? party.getAlly().getName() : ""));
            partiesFile.set(partyName + ".ExpShareMode", (Object)party.getXpShareMode().toString());
            partiesFile.set(partyName + ".ItemShareMode", (Object)party.getItemShareMode().toString());
            for (ItemShareType itemShareType : ItemShareType.values()) {
                partiesFile.set(partyName + ".ItemShareType." + itemShareType.toString(), (Object)party.sharingDrops(itemShareType));
            }
            ArrayList<String> members = new ArrayList<String>();
            for (Map.Entry<UUID, String> memberEntry : party.getMembers().entrySet()) {
                String memberUniqueId;
                String string = memberUniqueId = memberEntry.getKey() == null ? "" : memberEntry.getKey().toString();
                String memberName = memberEntry.getValue();
                if (members.contains(memberName)) continue;
                members.add(memberUniqueId + "|" + memberName);
            }
            partiesFile.set(partyName + ".Members", members);
        }
        try {
            partiesFile.save(partyFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadAndUpgradeParties() {
        YamlConfiguration partiesFile = YamlConfiguration.loadConfiguration((File)partyFile);
        if (!partyFile.renameTo(new File(mcMMO.getFlatFileDirectory() + "parties.yml.converted"))) {
            mcMMO.p.getLogger().severe("Could not rename parties.yml to parties.yml.converted!");
            return;
        }
        ArrayList<Party> hasAlly = new ArrayList<Party>();
        for (String partyName : partiesFile.getConfigurationSection("").getKeys(false)) {
            Party party = new Party(partyName);
            String leaderName = partiesFile.getString(partyName + ".Leader");
            PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(leaderName, false);
            if (!profile.isLoaded()) {
                mcMMO.p.getLogger().warning("Could not find UUID in database for party leader " + leaderName + " in party " + partyName);
                continue;
            }
            UUID leaderUniqueId = profile.getUniqueId();
            party.setLeader(new PartyLeader(leaderUniqueId, leaderName));
            party.setPassword(partiesFile.getString(partyName + ".Password"));
            party.setLocked(partiesFile.getBoolean(partyName + ".Locked"));
            party.setLevel(partiesFile.getInt(partyName + ".Level"));
            party.setXp(partiesFile.getInt(partyName + ".Xp"));
            if (partiesFile.getString(partyName + ".Ally") != null) {
                hasAlly.add(party);
            }
            party.setXpShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ExpShareMode", "NONE")));
            party.setItemShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ItemShareMode", "NONE")));
            for (ItemShareType itemShareType : ItemShareType.values()) {
                party.setSharingDrops(itemShareType, partiesFile.getBoolean(partyName + ".ItemShareType." + itemShareType.toString(), true));
            }
            LinkedHashMap<UUID, String> members = party.getMembers();
            for (String memberName : partiesFile.getStringList(partyName + ".Members")) {
                PlayerProfile memberProfile = mcMMO.getDatabaseManager().loadPlayerProfile(memberName, false);
                if (!memberProfile.isLoaded()) {
                    mcMMO.p.getLogger().warning("Could not find UUID in database for party member " + memberName + " in party " + partyName);
                    continue;
                }
                UUID memberUniqueId = memberProfile.getUniqueId();
                members.put(memberUniqueId, memberName);
            }
            parties.add(party);
        }
        mcMMO.p.debug("Loaded (" + parties.size() + ") Parties...");
        for (Party party : hasAlly) {
            party.setAlly(PartyManager.getParty(partiesFile.getString(party.getName() + ".Ally")));
        }
        mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS_PARTY);
    }

    public static boolean handlePartyChangeEvent(Player player, String oldPartyName, String newPartyName, McMMOPartyChangeEvent.EventReason reason) {
        McMMOPartyChangeEvent event = new McMMOPartyChangeEvent(player, oldPartyName, newPartyName, reason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handlePartyChangeAllianceEvent(Player player, String oldAllyName, String newAllyName, McMMOPartyAllianceChangeEvent.EventReason reason) {
        McMMOPartyAllianceChangeEvent event = new McMMOPartyAllianceChangeEvent(player, oldAllyName, newAllyName, reason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void processPartyLeaving(McMMOPlayer mcMMOPlayer) {
        mcMMOPlayer.removeParty();
        mcMMOPlayer.disableChat(ChatMode.PARTY);
        mcMMOPlayer.setItemShareModifier(10);
    }

    public static void informPartyMembersLevelUp(Party party, int levelsGained, int level) {
        boolean levelUpSoundsEnabled = Config.getInstance().getLevelUpSoundsEnabled();
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.LevelUp", levelsGained, level));
            if (!levelUpSoundsEnabled) continue;
            member.playSound(member.getLocation(), Sound.LEVEL_UP, 0.75f, 0.5f);
        }
    }

    private static void informPartyMembersJoin(Party party, String playerName) {
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.InformedOnJoin", playerName));
        }
    }

    private static void informPartyMembersQuit(Party party, String playerName) {
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.InformedOnQuit", playerName));
        }
    }
}

