/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import com.gmail.nossr50.events.fake.FakeBlockDamageEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private final mcMMO plugin;

    public BlockListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        BlockFace direction = event.getDirection();
        Block futureEmptyBlock = event.getBlock().getRelative(direction);
        if (futureEmptyBlock.getType() == Material.AIR) {
            return;
        }
        List blocks = event.getBlocks();
        for (Block b : blocks) {
            if (!BlockUtils.shouldBeWatched(b.getState()) || !mcMMO.getPlaceStore().isTrue(b)) continue;
            Block nextBlock = b.getRelative(direction);
            mcMMO.getPlaceStore().setTrue(nextBlock);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (event.getBlock().getType() != Material.PISTON_MOVING_PIECE) {
            return;
        }
        BlockFace direction = event.getDirection().getOppositeFace();
        Block movedBlock = event.getBlock().getRelative(direction);
        mcMMO.getPlaceStore().setTrue(movedBlock);
        if (movedBlock.getRelative(direction).getState().getType() == Material.SLIME_BLOCK) {
            for (Block block : event.getBlocks()) {
                movedBlock = block.getRelative(direction);
                mcMMO.getPlaceStore().setTrue(movedBlock);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFallingBlock(EntityChangeBlockEvent event) {
        if (BlockUtils.shouldBeWatched(event.getBlock().getState()) && event.getEntityType().equals((Object)EntityType.FALLING_BLOCK)) {
            if (event.getTo().equals((Object)Material.AIR) && mcMMO.getPlaceStore().isTrue(event.getBlock())) {
                event.getEntity().setMetadata("mcMMOBlockFall", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getBlock().getLocation()));
            } else {
                List values = event.getEntity().getMetadata("mcMMOBlockFall");
                if (!values.isEmpty()) {
                    if (((MetadataValue)values.get(0)).value() == null) {
                        return;
                    }
                    Block spawn = ((Location)((MetadataValue)values.get(0)).value()).getBlock();
                    mcMMO.getPlaceStore().setTrue(event.getBlock());
                    mcMMO.getPlaceStore().setFalse(spawn);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        if (BlockUtils.shouldBeWatched(blockState)) {
            mcMMO.getPlaceStore().setTrue(blockState);
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (blockState.getType() == Repair.anvilMaterial && SkillType.REPAIR.getPermissions(player)) {
            mcMMOPlayer.getRepairManager().placedAnvilCheck();
        } else if (blockState.getType() == Salvage.anvilMaterial && SkillType.SALVAGE.getPermissions(player)) {
            mcMMOPlayer.getSalvageManager().placedAnvilCheck();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player;
        if (event instanceof FakeBlockBreakEvent) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        Location location = blockState.getLocation();
        if (!BlockUtils.shouldBeWatched(blockState)) {
            return;
        }
        if (blockState instanceof BrewingStand && Alchemy.brewingStandMap.containsKey(location)) {
            Alchemy.brewingStandMap.get(location).cancelBrew();
        }
        if (!UserManager.hasPlayerDataKey((Entity)(player = event.getPlayer())) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ItemStack heldItem = player.getItemInHand();
        if (BlockUtils.affectedByGreenTerra(blockState)) {
            HerbalismManager herbalismManager = mcMMOPlayer.getHerbalismManager();
            if (herbalismManager.canActivateAbility()) {
                mcMMOPlayer.checkAbilityActivation(SkillType.HERBALISM);
            }
            if (SkillType.HERBALISM.getPermissions(player)) {
                herbalismManager.herbalismBlockCheck(blockState);
            }
        } else if (BlockUtils.affectedBySuperBreaker(blockState).booleanValue() && ItemUtils.isPickaxe(heldItem) && SkillType.MINING.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            MiningManager miningManager = mcMMOPlayer.getMiningManager();
            miningManager.miningBlockCheck(blockState);
        } else if (BlockUtils.isLog(blockState) && ItemUtils.isAxe(heldItem) && SkillType.WOODCUTTING.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            WoodcuttingManager woodcuttingManager = mcMMOPlayer.getWoodcuttingManager();
            if (woodcuttingManager.canUseTreeFeller(heldItem)) {
                woodcuttingManager.processTreeFeller(blockState);
            } else {
                woodcuttingManager.woodcuttingBlockCheck(blockState);
            }
        } else if (BlockUtils.affectedByGigaDrillBreaker(blockState) && ItemUtils.isShovel(heldItem) && SkillType.EXCAVATION.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            ExcavationManager excavationManager = mcMMOPlayer.getExcavationManager();
            excavationManager.excavationBlockCheck(blockState);
            if (mcMMOPlayer.getAbilityMode(AbilityType.GIGA_DRILL_BREAKER)) {
                excavationManager.gigaDrillBreaker(blockState);
            }
        }
        mcMMO.getPlaceStore().setFalse(blockState);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreakHigher(BlockBreakEvent event) {
        SmeltingManager smeltingManager;
        if (event instanceof FakeBlockBreakEvent) {
            return;
        }
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        ItemStack heldItem = player.getItemInHand();
        if (Herbalism.isRecentlyRegrown(blockState)) {
            event.setCancelled(true);
            return;
        }
        if (ItemUtils.isSword(heldItem)) {
            HerbalismManager herbalismManager = UserManager.getPlayer(player).getHerbalismManager();
            if (herbalismManager.canUseHylianLuck()) {
                if (herbalismManager.processHylianLuck(blockState)) {
                    blockState.update(true);
                    event.setCancelled(true);
                } else if (blockState.getType() == Material.FLOWER_POT) {
                    blockState.setType(Material.AIR);
                    blockState.update(true);
                    event.setCancelled(true);
                }
            }
        } else if (ItemUtils.isFluxPickaxe(heldItem) && !heldItem.containsEnchantment(Enchantment.SILK_TOUCH) && (smeltingManager = UserManager.getPlayer(player).getSmeltingManager()).canUseFluxMining(blockState) && smeltingManager.processFluxMining(blockState)) {
            blockState.update(true);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        if (event instanceof FakeBlockDamageEvent) {
            return;
        }
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        BlockState blockState = event.getBlock().getState();
        if (BlockUtils.canActivateAbilities(blockState)) {
            ItemStack heldItem = player.getItemInHand();
            if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
                if (ItemUtils.isPickaxe(heldItem) && !mcMMOPlayer.getAbilityMode(AbilityType.SUPER_BREAKER) || ItemUtils.isShovel(heldItem) && !mcMMOPlayer.getAbilityMode(AbilityType.GIGA_DRILL_BREAKER)) {
                    SkillUtils.removeAbilityBuff(heldItem);
                }
            } else if (mcMMOPlayer.getAbilityMode(AbilityType.SUPER_BREAKER) && !BlockUtils.affectedBySuperBreaker(blockState).booleanValue() || mcMMOPlayer.getAbilityMode(AbilityType.GIGA_DRILL_BREAKER) && !BlockUtils.affectedByGigaDrillBreaker(blockState)) {
                SkillUtils.handleAbilitySpeedDecrease(player);
            }
            if (mcMMOPlayer.getToolPreparationMode(ToolType.HOE) && ItemUtils.isHoe(heldItem) && (BlockUtils.affectedByGreenTerra(blockState) || BlockUtils.canMakeMossy(blockState)) && Permissions.greenTerra((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(SkillType.HERBALISM);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.AXE) && ItemUtils.isAxe(heldItem) && BlockUtils.isLog(blockState) && Permissions.treeFeller((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(SkillType.WOODCUTTING);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.PICKAXE) && ItemUtils.isPickaxe(heldItem) && BlockUtils.affectedBySuperBreaker(blockState).booleanValue() && Permissions.superBreaker((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(SkillType.MINING);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.SHOVEL) && ItemUtils.isShovel(heldItem) && BlockUtils.affectedByGigaDrillBreaker(blockState) && Permissions.gigaDrillBreaker((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(SkillType.EXCAVATION);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.FISTS) && heldItem.getType() == Material.AIR && (BlockUtils.affectedByGigaDrillBreaker(blockState) || blockState.getType() == Material.SNOW || BlockUtils.affectedByBlockCracker(blockState) && Permissions.berserk((Permissible)player))) {
                mcMMOPlayer.checkAbilityActivation(SkillType.UNARMED);
            }
        }
        if (mcMMOPlayer.getAbilityMode(AbilityType.TREE_FELLER) && BlockUtils.isLog(blockState) && Config.getInstance().getTreeFellerSoundsEnabled()) {
            player.playSound(blockState.getLocation(), Sound.FIZZ, 0.5f, Misc.getFizzPitch());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamageHigher(BlockDamageEvent event) {
        if (event instanceof FakeBlockDamageEvent) {
            return;
        }
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ItemStack heldItem = player.getItemInHand();
        Block block = event.getBlock();
        BlockState blockState = block.getState();
        if (mcMMOPlayer.getAbilityMode(AbilityType.GREEN_TERRA) && BlockUtils.canMakeMossy(blockState)) {
            if (mcMMOPlayer.getHerbalismManager().processGreenTerra(blockState)) {
                blockState.update(true);
            }
        } else if (mcMMOPlayer.getAbilityMode(AbilityType.BERSERK) && heldItem.getType() == Material.AIR) {
            if (AbilityType.BERSERK.blockCheck(block.getState()) && EventUtils.simulateBlockBreak(block, player, true)) {
                event.setInstaBreak(true);
                player.playSound(block.getLocation(), Sound.ITEM_PICKUP, 0.2f, Misc.getPopPitch());
            } else if (mcMMOPlayer.getUnarmedManager().canUseBlockCracker() && BlockUtils.affectedByBlockCracker(blockState) && EventUtils.simulateBlockBreak(block, player, true) && mcMMOPlayer.getUnarmedManager().blockCrackerCheck(blockState)) {
                blockState.update();
            }
        } else if (mcMMOPlayer.getWoodcuttingManager().canUseLeafBlower(heldItem) && BlockUtils.isLeaves(blockState) && EventUtils.simulateBlockBreak(block, player, true)) {
            event.setInstaBreak(true);
            player.playSound(blockState.getLocation(), Sound.ITEM_PICKUP, 0.2f, Misc.getPopPitch());
        }
    }
}

