/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.experience.SkillXpGain;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerProfileSaveTask;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import org.bukkit.plugin.Plugin;

public class PlayerProfile {
    private final String playerName;
    private UUID uuid;
    private boolean loaded;
    private volatile boolean changed;
    private MobHealthbarType mobHealthbarType;
    private int scoreboardTipsShown;
    private final Map<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
    private final Map<SkillType, Float> skillsXp = new HashMap<SkillType, Float>();
    private final Map<AbilityType, Integer> abilityDATS = new HashMap<AbilityType, Integer>();
    private DelayQueue<SkillXpGain> gainedSkillsXp = new DelayQueue();
    private HashMap<SkillType, Float> rollingSkillsXp = new HashMap();

    @Deprecated
    public PlayerProfile(String playerName) {
        this(playerName, null);
    }

    public PlayerProfile(String playerName, UUID uuid) {
        this.uuid = uuid;
        this.playerName = playerName;
        this.mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        this.scoreboardTipsShown = 0;
        for (AbilityType abilityType : AbilityType.values()) {
            this.abilityDATS.put(abilityType, 0);
        }
        for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
            this.skills.put(skillType, 0);
            this.skillsXp.put(skillType, Float.valueOf(0.0f));
        }
    }

    @Deprecated
    public PlayerProfile(String playerName, boolean isLoaded) {
        this(playerName);
        this.loaded = isLoaded;
    }

    public PlayerProfile(String playerName, UUID uuid, boolean isLoaded) {
        this(playerName, uuid);
        this.loaded = isLoaded;
    }

    public PlayerProfile(String playerName, UUID uuid, Map<SkillType, Integer> levelData, Map<SkillType, Float> xpData, Map<AbilityType, Integer> cooldownData, MobHealthbarType mobHealthbarType, int scoreboardTipsShown) {
        this.playerName = playerName;
        this.uuid = uuid;
        this.mobHealthbarType = mobHealthbarType;
        this.scoreboardTipsShown = scoreboardTipsShown;
        this.skills.putAll(levelData);
        this.skillsXp.putAll(xpData);
        this.abilityDATS.putAll(cooldownData);
        this.loaded = true;
    }

    public void scheduleAsyncSave() {
        new PlayerProfileSaveTask(this).runTaskAsynchronously((Plugin)mcMMO.p);
    }

    public void save() {
        if (!this.changed || !this.loaded) {
            return;
        }
        PlayerProfile profileCopy = new PlayerProfile(this.playerName, this.uuid, (Map<SkillType, Integer>)ImmutableMap.copyOf(this.skills), (Map<SkillType, Float>)ImmutableMap.copyOf(this.skillsXp), (Map<AbilityType, Integer>)ImmutableMap.copyOf(this.abilityDATS), this.mobHealthbarType, this.scoreboardTipsShown);
        boolean bl = this.changed = !mcMMO.getDatabaseManager().saveUser(profileCopy);
        if (this.changed) {
            mcMMO.p.getLogger().warning("PlayerProfile saving failed for player: " + this.playerName + " " + this.uuid);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public void setUniqueId(UUID uuid) {
        this.changed = true;
        this.uuid = uuid;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public MobHealthbarType getMobHealthbarType() {
        return this.mobHealthbarType;
    }

    public void setMobHealthbarType(MobHealthbarType mobHealthbarType) {
        this.changed = true;
        this.mobHealthbarType = mobHealthbarType;
    }

    public int getScoreboardTipsShown() {
        return this.scoreboardTipsShown;
    }

    public void setScoreboardTipsShown(int scoreboardTipsShown) {
        this.changed = true;
        this.scoreboardTipsShown = scoreboardTipsShown;
    }

    public void increaseTipsShown() {
        this.setScoreboardTipsShown(this.getScoreboardTipsShown() + 1);
    }

    public long getAbilityDATS(AbilityType ability) {
        return this.abilityDATS.get((Object)ability).intValue();
    }

    protected void setAbilityDATS(AbilityType ability, long DATS) {
        this.changed = true;
        this.abilityDATS.put(ability, (int)((double)DATS * 0.001));
    }

    protected void resetCooldowns() {
        this.changed = true;
        for (AbilityType ability : this.abilityDATS.keySet()) {
            this.abilityDATS.put(ability, 0);
        }
    }

    public int getSkillLevel(SkillType skill) {
        return skill.isChildSkill() ? this.getChildSkillLevel(skill) : this.skills.get((Object)skill).intValue();
    }

    public float getSkillXpLevelRaw(SkillType skill) {
        return this.skillsXp.get((Object)skill).floatValue();
    }

    public int getSkillXpLevel(SkillType skill) {
        return (int)Math.floor(this.getSkillXpLevelRaw(skill));
    }

    public void setSkillXpLevel(SkillType skill, float xpLevel) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skillsXp.put(skill, Float.valueOf(xpLevel));
    }

    protected float levelUp(SkillType skill) {
        float xpRemoved = this.getXpToLevel(skill);
        this.changed = true;
        this.skills.put(skill, this.skills.get((Object)skill) + 1);
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - xpRemoved));
        return xpRemoved;
    }

    public void removeXp(SkillType skill, int xp) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - (float)xp));
    }

    public void removeXp(SkillType skill, float xp) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - xp));
    }

    public void modifySkill(SkillType skill, int level) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skills.put(skill, level);
        this.skillsXp.put(skill, Float.valueOf(0.0f));
    }

    public void addLevels(SkillType skill, int levels) {
        this.modifySkill(skill, this.skills.get((Object)skill) + levels);
    }

    public void addXp(SkillType skill, float xp) {
        this.changed = true;
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            float dividedXP = xp / (float)parentSkills.size();
            for (SkillType parentSkill : parentSkills) {
                this.skillsXp.put(parentSkill, Float.valueOf(this.skillsXp.get((Object)parentSkill).floatValue() + dividedXP));
            }
        } else {
            this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() + xp));
        }
    }

    public float getRegisteredXpGain(SkillType skillType) {
        float xp = 0.0f;
        if (this.rollingSkillsXp.get((Object)skillType) != null) {
            xp = this.rollingSkillsXp.get((Object)skillType).floatValue();
        }
        return xp;
    }

    public void registerXpGain(SkillType skillType, float xp) {
        this.gainedSkillsXp.add(new SkillXpGain(skillType, xp));
        this.rollingSkillsXp.put(skillType, Float.valueOf(this.getRegisteredXpGain(skillType) + xp));
    }

    public void purgeExpiredXpGains() {
        SkillXpGain gain;
        while ((gain = (SkillXpGain)this.gainedSkillsXp.poll()) != null) {
            this.rollingSkillsXp.put(gain.getSkill(), Float.valueOf(this.getRegisteredXpGain(gain.getSkill()) - gain.getXp()));
        }
    }

    public int getXpToLevel(SkillType skillType) {
        int level = ExperienceConfig.getInstance().getCumulativeCurveEnabled() ? UserManager.getPlayer(this.playerName).getPowerLevel() : this.skills.get((Object)skillType).intValue();
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getCachedXpToLevel(level, formulaType);
    }

    private int getChildSkillLevel(SkillType skillType) {
        Set<SkillType> parents = FamilyTree.getParents(skillType);
        int sum = 0;
        for (SkillType parent : parents) {
            sum += Math.min(this.getSkillLevel(parent), parent.getMaxLevel());
        }
        return sum / parents.size();
    }
}

