/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.SkillType;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class SkillXpGain
implements Delayed {
    private final long expiryTime = System.currentTimeMillis() + SkillXpGain.getDuration();
    private final float xp;
    private final SkillType type;

    public SkillXpGain(SkillType type, float xp) {
        this.xp = xp;
        this.type = type;
    }

    public SkillType getSkill() {
        return this.type;
    }

    public float getXp() {
        return this.xp;
    }

    private static long getDuration() {
        return TimeUnit.MINUTES.toMillis(ExperienceConfig.getInstance().getDiminishedReturnsTimeInterval());
    }

    @Override
    public int compareTo(SkillXpGain other) {
        if (this.expiryTime < other.expiryTime) {
            return -1;
        }
        if (this.expiryTime > other.expiryTime) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other instanceof SkillXpGain) {
            return this.compareTo((SkillXpGain)other);
        }
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public long getDelay(TimeUnit arg0) {
        return arg0.convert(this.expiryTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

