/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTimeoutInterceptor
extends AbstractCreateStatementInterceptor {
    private static Log log = LogFactory.getLog(QueryTimeoutInterceptor.class);
    int timeout;

    @Override
    public void setProperties(Map<String, PoolProperties.InterceptorProperty> properties) {
        super.setProperties(properties);
        this.timeout = properties.get("queryTimeout").getValueAsInt(-1);
    }

    @Override
    public Object createStatement(Object proxy, Method method, Object[] args, Object statement, long time) {
        if (statement instanceof Statement && this.timeout > 0) {
            Statement s = (Statement)statement;
            try {
                s.setQueryTimeout(this.timeout);
            }
            catch (SQLException x) {
                log.warn("[QueryTimeoutInterceptor] Unable to set query timeout:" + x.getMessage(), x);
            }
        }
        return statement;
    }

    @Override
    public void closeInvoked() {
    }
}

