/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSource;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.UUIDUpdateAsyncTask;
import com.gmail.nossr50.util.Misc;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SQLDatabaseManager
implements DatabaseManager {
    private static final String ALL_QUERY_VERSION = "taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy";
    private String tablePrefix = Config.getInstance().getMySQLTablePrefix();
    private final Map<UUID, Integer> cachedUserIDs = new HashMap<UUID, Integer>();
    private DataSource miscPool;
    private DataSource loadPool;
    private DataSource savePool;
    private ReentrantLock massUpdateLock = new ReentrantLock();

    protected SQLDatabaseManager() {
        String connectionString = "jdbc:mysql://" + Config.getInstance().getMySQLServerName() + ":" + Config.getInstance().getMySQLServerPort() + "/" + Config.getInstance().getMySQLDatabaseName();
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(connectionString);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.MISC));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.MISC));
        poolProperties.setInitialSize(0);
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.miscPool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(connectionString);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.SAVE));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.SAVE));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.savePool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(connectionString);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.LOAD));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.LOAD));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.loadPool = new DataSource(poolProperties);
        this.checkStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePowerlessUsers() {
        this.massUpdateLock.lock();
        mcMMO.p.getLogger().info("Purging powerless users...");
        Connection connection = null;
        Statement statement = null;
        int purged = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            purged = statement.executeUpdate("DELETE FROM " + this.tablePrefix + "skills WHERE " + "taming = 0 AND mining = 0 AND woodcutting = 0 AND repair = 0 " + "AND unarmed = 0 AND herbalism = 0 AND excavation = 0 AND " + "archery = 0 AND swords = 0 AND axes = 0 AND acrobatics = 0 " + "AND fishing = 0 AND alchemy = 0;");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "experience`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "huds`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "users` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "users`.`id` = `s`.`user_id`)");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        mcMMO.p.getLogger().info("Purged " + purged + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        this.massUpdateLock.lock();
        mcMMO.p.getLogger().info("Purging inactive users older than " + PURGE_TIME / 2630000000L + " months...");
        Connection connection = null;
        Statement statement = null;
        int purged = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            purged = statement.executeUpdate("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "WHERE ((UNIX_TIMESTAMP() - lastlogin) > " + PURGE_TIME + ")");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException ex) {
            try {
                this.printErrors(ex);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        mcMMO.p.getLogger().info("Purged " + purged + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String playerName) {
        boolean success = false;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "WHERE u.user = ?");
            statement.setString(1, playerName);
            success = statement.executeUpdate() != 0;
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
        if (success) {
            Misc.profileCleanup(playerName);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(PlayerProfile profile) {
        Connection connection;
        PreparedStatement statement;
        boolean success;
        block21: {
            boolean bl;
            block20: {
                boolean bl2;
                block19: {
                    boolean bl3;
                    block18: {
                        boolean bl4;
                        block17: {
                            boolean bl5;
                            block16: {
                                success = true;
                                statement = null;
                                connection = null;
                                try {
                                    connection = this.getConnection(PoolIdentifier.SAVE);
                                    int id = this.getUserID(connection, profile.getPlayerName(), profile.getUniqueId());
                                    if (id == -1 && (id = this.newUser(connection, profile.getPlayerName(), profile.getUniqueId())) == -1) {
                                        mcMMO.p.getLogger().severe("Failed to create new account for " + profile.getPlayerName());
                                        boolean bl6 = false;
                                        this.tryClose(statement);
                                        this.tryClose(connection);
                                        return bl6;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET lastlogin = UNIX_TIMESTAMP() WHERE id = ?");
                                    statement.setInt(1, id);
                                    boolean bl7 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl7)) {
                                        mcMMO.p.getLogger().severe("Failed to update last login for " + profile.getPlayerName());
                                        bl5 = false;
                                        this.tryClose(statement);
                                        break block16;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "skills SET " + " taming = ?, mining = ?, repair = ?, woodcutting = ?" + ", unarmed = ?, herbalism = ?, excavation = ?" + ", archery = ?, swords = ?, axes = ?, acrobatics = ?" + ", fishing = ?, alchemy = ? WHERE user_id = ?");
                                    statement.setInt(1, profile.getSkillLevel(SkillType.TAMING));
                                    statement.setInt(2, profile.getSkillLevel(SkillType.MINING));
                                    statement.setInt(3, profile.getSkillLevel(SkillType.REPAIR));
                                    statement.setInt(4, profile.getSkillLevel(SkillType.WOODCUTTING));
                                    statement.setInt(5, profile.getSkillLevel(SkillType.UNARMED));
                                    statement.setInt(6, profile.getSkillLevel(SkillType.HERBALISM));
                                    statement.setInt(7, profile.getSkillLevel(SkillType.EXCAVATION));
                                    statement.setInt(8, profile.getSkillLevel(SkillType.ARCHERY));
                                    statement.setInt(9, profile.getSkillLevel(SkillType.SWORDS));
                                    statement.setInt(10, profile.getSkillLevel(SkillType.AXES));
                                    statement.setInt(11, profile.getSkillLevel(SkillType.ACROBATICS));
                                    statement.setInt(12, profile.getSkillLevel(SkillType.FISHING));
                                    statement.setInt(13, profile.getSkillLevel(SkillType.ALCHEMY));
                                    statement.setInt(14, id);
                                    boolean bl8 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl8)) {
                                        mcMMO.p.getLogger().severe("Failed to update skills for " + profile.getPlayerName());
                                        bl4 = false;
                                        this.tryClose(statement);
                                        break block17;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "experience SET " + " taming = ?, mining = ?, repair = ?, woodcutting = ?" + ", unarmed = ?, herbalism = ?, excavation = ?" + ", archery = ?, swords = ?, axes = ?, acrobatics = ?" + ", fishing = ?, alchemy = ? WHERE user_id = ?");
                                    statement.setInt(1, profile.getSkillXpLevel(SkillType.TAMING));
                                    statement.setInt(2, profile.getSkillXpLevel(SkillType.MINING));
                                    statement.setInt(3, profile.getSkillXpLevel(SkillType.REPAIR));
                                    statement.setInt(4, profile.getSkillXpLevel(SkillType.WOODCUTTING));
                                    statement.setInt(5, profile.getSkillXpLevel(SkillType.UNARMED));
                                    statement.setInt(6, profile.getSkillXpLevel(SkillType.HERBALISM));
                                    statement.setInt(7, profile.getSkillXpLevel(SkillType.EXCAVATION));
                                    statement.setInt(8, profile.getSkillXpLevel(SkillType.ARCHERY));
                                    statement.setInt(9, profile.getSkillXpLevel(SkillType.SWORDS));
                                    statement.setInt(10, profile.getSkillXpLevel(SkillType.AXES));
                                    statement.setInt(11, profile.getSkillXpLevel(SkillType.ACROBATICS));
                                    statement.setInt(12, profile.getSkillXpLevel(SkillType.FISHING));
                                    statement.setInt(13, profile.getSkillXpLevel(SkillType.ALCHEMY));
                                    statement.setInt(14, id);
                                    boolean bl9 = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!(success &= bl9)) {
                                        mcMMO.p.getLogger().severe("Failed to update experience for " + profile.getPlayerName());
                                        bl3 = false;
                                        this.tryClose(statement);
                                        break block18;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "cooldowns SET " + "  mining = ?, woodcutting = ?, unarmed = ?" + ", herbalism = ?, excavation = ?, swords = ?" + ", axes = ?, blast_mining = ? WHERE user_id = ?");
                                    statement.setLong(1, profile.getAbilityDATS(AbilityType.SUPER_BREAKER));
                                    statement.setLong(2, profile.getAbilityDATS(AbilityType.TREE_FELLER));
                                    statement.setLong(3, profile.getAbilityDATS(AbilityType.BERSERK));
                                    statement.setLong(4, profile.getAbilityDATS(AbilityType.GREEN_TERRA));
                                    statement.setLong(5, profile.getAbilityDATS(AbilityType.GIGA_DRILL_BREAKER));
                                    statement.setLong(6, profile.getAbilityDATS(AbilityType.SERRATED_STRIKES));
                                    statement.setLong(7, profile.getAbilityDATS(AbilityType.SKULL_SPLITTER));
                                    statement.setLong(8, profile.getAbilityDATS(AbilityType.BLAST_MINING));
                                    statement.setInt(9, id);
                                    success = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!success) {
                                        mcMMO.p.getLogger().severe("Failed to update cooldowns for " + profile.getPlayerName());
                                        bl2 = false;
                                        this.tryClose(statement);
                                        break block19;
                                    }
                                    statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ?, scoreboardtips = ? WHERE user_id = ?");
                                    statement.setString(1, profile.getMobHealthbarType() == null ? Config.getInstance().getMobHealthbarDefault().name() : profile.getMobHealthbarType().name());
                                    statement.setInt(2, profile.getScoreboardTipsShown());
                                    statement.setInt(3, id);
                                    success = statement.executeUpdate() != 0;
                                    statement.close();
                                    if (!success) {
                                        mcMMO.p.getLogger().severe("Failed to update hud settings for " + profile.getPlayerName());
                                        bl = false;
                                        this.tryClose(statement);
                                        break block20;
                                    }
                                    this.tryClose(statement);
                                    break block21;
                                }
                                catch (SQLException ex) {
                                    this.printErrors(ex);
                                    return success;
                                }
                            }
                            this.tryClose(connection);
                            return bl5;
                        }
                        this.tryClose(connection);
                        return bl4;
                    }
                    this.tryClose(connection);
                    return bl3;
                }
                this.tryClose(connection);
                return bl2;
            }
            this.tryClose(connection);
            return bl;
        }
        this.tryClose(connection);
        return success;
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlayerStat> readLeaderboard(SkillType skill, int pageNumber, int statsPerPage) {
        ArrayList<PlayerStat> stats = new ArrayList<PlayerStat>();
        String query = skill == null ? ALL_QUERY_VERSION : skill.name().toLowerCase();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("SELECT " + query + ", user, NOW() FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON (user_id = id) WHERE " + query + " > 0 AND NOT user = '\\_INVALID\\_OLD\\_USERNAME\\_' ORDER BY " + query + " DESC, user LIMIT ?, ?");
            statement.setInt(1, pageNumber * statsPerPage - statsPerPage);
            statement.setInt(2, statsPerPage);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ArrayList<String> column = new ArrayList<String>();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    column.add(resultSet.getString(i));
                }
                stats.add(new PlayerStat((String)column.get(1), Integer.valueOf((String)column.get(0))));
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<SkillType, Integer> readRank(String playerName) {
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
                String skillName = skillType.name().toLowerCase();
                String sql = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 " + "AND " + skillName + " > (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE user = ?)";
                statement = connection.prepareStatement(sql);
                statement.setString(1, playerName);
                resultSet = statement.executeQuery();
                resultSet.next();
                int rank = resultSet.getInt("rank");
                sql = "SELECT user, " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 " + "AND " + skillName + " = (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE user = '" + playerName + "') ORDER BY user";
                resultSet.close();
                statement.close();
                statement = connection.prepareStatement(sql);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                    skills.put(skillType, rank + resultSet.getRow());
                    break;
                }
                resultSet.close();
                statement.close();
            }
            String sql = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE " + ALL_QUERY_VERSION + " > 0 " + "AND " + ALL_QUERY_VERSION + " > " + "(SELECT " + ALL_QUERY_VERSION + " " + "FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?)";
            statement = connection.prepareStatement(sql);
            statement.setString(1, playerName);
            resultSet = statement.executeQuery();
            resultSet.next();
            int rank = resultSet.getInt("rank");
            resultSet.close();
            statement.close();
            sql = "SELECT user, taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE " + ALL_QUERY_VERSION + " > 0 " + "AND " + ALL_QUERY_VERSION + " = " + "(SELECT " + ALL_QUERY_VERSION + " " + "FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?) ORDER BY user";
            statement = connection.prepareStatement(sql);
            statement.setString(1, playerName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                skills.put(null, rank + resultSet.getRow());
                break;
            }
            resultSet.close();
            statement.close();
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return skills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String playerName, UUID uuid) {
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            this.newUser(connection, playerName, uuid);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newUser(Connection connection, String playerName, UUID uuid) {
        block7: {
            int n;
            ResultSet resultSet = null;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` " + "SET user = ? " + "WHERE user = ?");
                statement.setString(1, "_INVALID_OLD_USERNAME_");
                statement.setString(2, playerName);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement("INSERT INTO " + this.tablePrefix + "users (user, uuid, lastlogin) VALUES (?, ?, UNIX_TIMESTAMP())", 1);
                statement.setString(1, playerName);
                statement.setString(2, uuid != null ? uuid.toString() : null);
                statement.executeUpdate();
                resultSet = statement.getGeneratedKeys();
                if (!resultSet.next()) {
                    mcMMO.p.getLogger().severe("Unable to create new user account in DB");
                    int n2 = -1;
                    this.tryClose(resultSet);
                    this.tryClose(statement);
                    return n2;
                }
                this.writeMissingRows(connection, resultSet.getInt(1));
                n = resultSet.getInt(1);
                this.tryClose(resultSet);
            }
            catch (SQLException ex) {
                this.printErrors(ex);
                break block7;
            }
            finally {
                this.tryClose(resultSet);
                this.tryClose(statement);
            }
            this.tryClose(statement);
            return n;
        }
        return -1;
    }

    @Override
    @Deprecated
    public PlayerProfile loadPlayerProfile(String playerName, boolean create) {
        return this.loadPlayerProfile(playerName, null, false, true);
    }

    @Override
    public PlayerProfile loadPlayerProfile(UUID uuid) {
        return this.loadPlayerProfile("", uuid, false, true);
    }

    @Override
    public PlayerProfile loadPlayerProfile(String playerName, UUID uuid, boolean create) {
        return this.loadPlayerProfile(playerName, uuid, create, true);
    }

    /*
     * Exception decompiling
     */
    private PlayerProfile loadPlayerProfile(String playerName, UUID uuid, boolean create, boolean retry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        PreparedStatement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("SELECT s.taming, s.mining, s.repair, s.woodcutting, s.unarmed, s.herbalism, s.excavation, s.archery, s.swords, s.axes, s.acrobatics, s.fishing, s.alchemy, e.taming, e.mining, e.repair, e.woodcutting, e.unarmed, e.herbalism, e.excavation, e.archery, e.swords, e.axes, e.acrobatics, e.fishing, e.alchemy, c.taming, c.mining, c.repair, c.woodcutting, c.unarmed, c.herbalism, c.excavation, c.archery, c.swords, c.axes, c.acrobatics, c.blast_mining, h.mobhealthbar, h.scoreboardtips, u.uuid FROM " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "WHERE u.user = ?");
            List<String> usernames = this.getStoredUsers();
            int convertedUsers = 0;
            long startMillis = System.currentTimeMillis();
            for (String playerName : usernames) {
                statement.setString(1, playerName);
                try {
                    resultSet = statement.executeQuery();
                    resultSet.next();
                    destination.saveUser(this.loadFromResult(playerName, resultSet));
                    resultSet.close();
                }
                catch (SQLException e) {
                    this.printErrors(e);
                }
                Misc.printProgress(++convertedUsers, 200, startMillis);
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException e) {
            this.printErrors(e);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String userName, UUID uuid) {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` SET " + "  uuid = ? WHERE user = ?");
            statement.setString(1, uuid.toString());
            statement.setString(2, userName);
            statement.execute();
            boolean bl = true;
            this.tryClose(statement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> fetchedUUIDs) {
        PreparedStatement statement = null;
        int count = 0;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET uuid = ? WHERE user = ?");
            for (Map.Entry<String, UUID> entry : fetchedUUIDs.entrySet()) {
                statement.setString(1, entry.getValue().toString());
                statement.setString(2, entry.getKey());
                statement.addBatch();
                if (++count % 500 != 0) continue;
                statement.executeBatch();
                count = 0;
            }
            if (count != 0) {
                statement.executeBatch();
            }
            boolean bl = true;
            this.tryClose(statement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        Statement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT user FROM " + this.tablePrefix + "users");
            while (resultSet.next()) {
                users.add(resultSet.getString("user"));
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException e) {
            this.printErrors(e);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        PreparedStatement statement = null;
        Statement createStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.prepareStatement("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = ? AND table_name = ?");
            statement.setString(1, Config.getInstance().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + "users");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "users` (" + "`id` int(10) unsigned NOT NULL AUTO_INCREMENT," + "`user` varchar(40) NOT NULL," + "`uuid` varchar(36) NULL DEFAULT NULL," + "`lastlogin` int(32) unsigned NOT NULL," + "PRIMARY KEY (`id`)," + "INDEX(`user`(20) ASC)," + "UNIQUE KEY `uuid` (`uuid`)) DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            statement.setString(1, Config.getInstance().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + "huds");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "huds` (" + "`user_id` int(10) unsigned NOT NULL," + "`mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "'," + "`scoreboardtips` int(10) NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            statement.setString(1, Config.getInstance().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + "cooldowns");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "cooldowns` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(32) unsigned NOT NULL DEFAULT '0'," + "`mining` int(32) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(32) unsigned NOT NULL DEFAULT '0'," + "`repair` int(32) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(32) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(32) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(32) unsigned NOT NULL DEFAULT '0'," + "`archery` int(32) unsigned NOT NULL DEFAULT '0'," + "`swords` int(32) unsigned NOT NULL DEFAULT '0'," + "`axes` int(32) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(32) unsigned NOT NULL DEFAULT '0'," + "`blast_mining` int(32) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            statement.setString(1, Config.getInstance().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + "skills");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "skills` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(10) unsigned NOT NULL DEFAULT '0'," + "`mining` int(10) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(10) unsigned NOT NULL DEFAULT '0'," + "`repair` int(10) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(10) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(10) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(10) unsigned NOT NULL DEFAULT '0'," + "`archery` int(10) unsigned NOT NULL DEFAULT '0'," + "`swords` int(10) unsigned NOT NULL DEFAULT '0'," + "`axes` int(10) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(10) unsigned NOT NULL DEFAULT '0'," + "`fishing` int(10) unsigned NOT NULL DEFAULT '0'," + "`alchemy` int(10) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            statement.setString(1, Config.getInstance().getMySQLDatabaseName());
            statement.setString(2, this.tablePrefix + "experience");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                createStatement = connection.createStatement();
                createStatement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "experience` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(10) unsigned NOT NULL DEFAULT '0'," + "`mining` int(10) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(10) unsigned NOT NULL DEFAULT '0'," + "`repair` int(10) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(10) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(10) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(10) unsigned NOT NULL DEFAULT '0'," + "`archery` int(10) unsigned NOT NULL DEFAULT '0'," + "`swords` int(10) unsigned NOT NULL DEFAULT '0'," + "`axes` int(10) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(10) unsigned NOT NULL DEFAULT '0'," + "`fishing` int(10) unsigned NOT NULL DEFAULT '0'," + "`alchemy` int(10) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
                this.tryClose(createStatement);
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            for (UpgradeType updateType : UpgradeType.values()) {
                this.checkDatabaseStructure(connection, updateType);
            }
            if (Config.getInstance().getTruncateSkills()) {
                for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
                    int cap = Config.getInstance().getLevelCap(skill);
                    if (cap == Integer.MAX_VALUE) continue;
                    statement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "skills` SET `" + skill.name().toLowerCase() + "` = " + cap + " WHERE `" + skill.name().toLowerCase() + "` > " + cap);
                    statement.executeUpdate();
                    this.tryClose(statement);
                }
            }
            mcMMO.p.getLogger().info("Killing orphans");
            createStatement = connection.createStatement();
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "experience`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "huds`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `u`.`id`)");
            createStatement.executeUpdate("DELETE FROM `" + this.tablePrefix + "skills` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "skills`.`user_id` = `u`.`id`)");
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(createStatement);
            this.tryClose(connection);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(createStatement);
            this.tryClose(connection);
        }
    }

    private Connection getConnection(PoolIdentifier identifier) throws SQLException {
        Connection connection = null;
        switch (identifier) {
            case LOAD: {
                connection = this.loadPool.getConnection();
                break;
            }
            case MISC: {
                connection = this.miscPool.getConnection();
                break;
            }
            case SAVE: {
                connection = this.savePool.getConnection();
            }
        }
        if (connection == null) {
            throw new RuntimeException("getConnection() for " + identifier.name().toLowerCase() + " pool timed out.  Increase max connections settings.");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseStructure(Connection connection, UpgradeType upgrade) {
        if (!mcMMO.getUpgradeManager().shouldUpgrade(upgrade)) {
            mcMMO.p.debug("Skipping " + upgrade.name() + " upgrade (unneeded)");
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            switch (upgrade) {
                case ADD_FISHING: {
                    this.checkUpgradeAddFishing(statement);
                    break;
                }
                case ADD_BLAST_MINING_COOLDOWN: {
                    this.checkUpgradeAddBlastMiningCooldown(statement);
                    break;
                }
                case ADD_SQL_INDEXES: {
                    this.checkUpgradeAddSQLIndexes(statement);
                    break;
                }
                case ADD_MOB_HEALTHBARS: {
                    this.checkUpgradeAddMobHealthbars(statement);
                    break;
                }
                case DROP_SQL_PARTY_NAMES: {
                    this.checkUpgradeDropPartyNames(statement);
                    break;
                }
                case DROP_SPOUT: {
                    this.checkUpgradeDropSpout(statement);
                    break;
                }
                case ADD_ALCHEMY: {
                    this.checkUpgradeAddAlchemy(statement);
                    break;
                }
                case ADD_UUIDS: {
                    this.checkUpgradeAddUUIDs(statement);
                    return;
                }
                case ADD_SCOREBOARD_TIPS: {
                    this.checkUpgradeAddScoreboardTips(statement);
                    return;
                }
                case DROP_NAME_UNIQUENESS: {
                    this.checkNameUniqueness(statement);
                    return;
                }
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(upgrade);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingRows(Connection connection, int id) {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "experience (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "skills (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "cooldowns (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "huds (user_id, mobhealthbar, scoreboardtips) VALUES (?, ?, ?)");
            statement.setInt(1, id);
            statement.setString(2, Config.getInstance().getMobHealthbarDefault().name());
            statement.setInt(3, 0);
            statement.execute();
            statement.close();
            this.tryClose(statement);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(statement);
        }
    }

    private PlayerProfile loadFromResult(String playerName, ResultSet result) throws SQLException {
        UUID uuid;
        int scoreboardTipsShown;
        MobHealthbarType mobHealthbarType;
        EnumMap<SkillType, Integer> skills = new EnumMap<SkillType, Integer>(SkillType.class);
        EnumMap<SkillType, Float> skillsXp = new EnumMap<SkillType, Float>(SkillType.class);
        EnumMap<AbilityType, Integer> skillsDATS = new EnumMap<AbilityType, Integer>(AbilityType.class);
        boolean OFFSET_SKILLS = false;
        int OFFSET_XP = 13;
        int OFFSET_DATS = 26;
        int OFFSET_OTHER = 38;
        skills.put(SkillType.TAMING, result.getInt(1));
        skills.put(SkillType.MINING, result.getInt(2));
        skills.put(SkillType.REPAIR, result.getInt(3));
        skills.put(SkillType.WOODCUTTING, result.getInt(4));
        skills.put(SkillType.UNARMED, result.getInt(5));
        skills.put(SkillType.HERBALISM, result.getInt(6));
        skills.put(SkillType.EXCAVATION, result.getInt(7));
        skills.put(SkillType.ARCHERY, result.getInt(8));
        skills.put(SkillType.SWORDS, result.getInt(9));
        skills.put(SkillType.AXES, result.getInt(10));
        skills.put(SkillType.ACROBATICS, result.getInt(11));
        skills.put(SkillType.FISHING, result.getInt(12));
        skills.put(SkillType.ALCHEMY, result.getInt(13));
        skillsXp.put(SkillType.TAMING, Float.valueOf(result.getFloat(14)));
        skillsXp.put(SkillType.MINING, Float.valueOf(result.getFloat(15)));
        skillsXp.put(SkillType.REPAIR, Float.valueOf(result.getFloat(16)));
        skillsXp.put(SkillType.WOODCUTTING, Float.valueOf(result.getFloat(17)));
        skillsXp.put(SkillType.UNARMED, Float.valueOf(result.getFloat(18)));
        skillsXp.put(SkillType.HERBALISM, Float.valueOf(result.getFloat(19)));
        skillsXp.put(SkillType.EXCAVATION, Float.valueOf(result.getFloat(20)));
        skillsXp.put(SkillType.ARCHERY, Float.valueOf(result.getFloat(21)));
        skillsXp.put(SkillType.SWORDS, Float.valueOf(result.getFloat(22)));
        skillsXp.put(SkillType.AXES, Float.valueOf(result.getFloat(23)));
        skillsXp.put(SkillType.ACROBATICS, Float.valueOf(result.getFloat(24)));
        skillsXp.put(SkillType.FISHING, Float.valueOf(result.getFloat(25)));
        skillsXp.put(SkillType.ALCHEMY, Float.valueOf(result.getFloat(26)));
        skillsDATS.put(AbilityType.SUPER_BREAKER, result.getInt(28));
        skillsDATS.put(AbilityType.TREE_FELLER, result.getInt(30));
        skillsDATS.put(AbilityType.BERSERK, result.getInt(31));
        skillsDATS.put(AbilityType.GREEN_TERRA, result.getInt(32));
        skillsDATS.put(AbilityType.GIGA_DRILL_BREAKER, result.getInt(33));
        skillsDATS.put(AbilityType.SERRATED_STRIKES, result.getInt(35));
        skillsDATS.put(AbilityType.SKULL_SPLITTER, result.getInt(36));
        skillsDATS.put(AbilityType.BLAST_MINING, result.getInt(38));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(result.getString(39));
        }
        catch (Exception e) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        try {
            scoreboardTipsShown = result.getInt(40);
        }
        catch (Exception e) {
            scoreboardTipsShown = 0;
        }
        try {
            uuid = UUID.fromString(result.getString(41));
        }
        catch (Exception e) {
            uuid = null;
        }
        return new PlayerProfile(playerName, uuid, skills, skillsXp, skillsDATS, mobHealthbarType, scoreboardTipsShown);
    }

    private void printErrors(SQLException ex) {
        StackTraceElement element = ex.getStackTrace()[0];
        mcMMO.p.getLogger().severe("Location: " + element.getClassName() + " " + element.getMethodName() + " " + element.getLineNumber());
        mcMMO.p.getLogger().severe("SQLException: " + ex.getMessage());
        mcMMO.p.getLogger().severe("SQLState: " + ex.getSQLState());
        mcMMO.p.getLogger().severe("VendorError: " + ex.getErrorCode());
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameUniqueness(Statement statement) throws SQLException {
        ResultSet resultSet;
        block4: {
            resultSet = null;
            resultSet = statement.executeQuery("SHOW INDEXES FROM `" + this.tablePrefix + "users` " + "WHERE Column_name='user' " + " AND NOT Non_unique");
            if (resultSet.next()) break block4;
            this.tryClose(resultSet);
            return;
        }
        try {
            resultSet.close();
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables to drop name uniqueness...");
            statement.execute("ALTER TABLE `" + this.tablePrefix + "users` " + "DROP INDEX `user`," + "ADD INDEX `user` (`user`(20) ASC)");
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            this.tryClose(resultSet);
        }
        catch (Throwable throwable) {
            this.tryClose(resultSet);
            throw throwable;
        }
    }

    private void checkUpgradeAddAlchemy(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `alchemy` FROM `" + this.tablePrefix + "skills` LIMIT 1");
        }
        catch (SQLException ex) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Alchemy...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddBlastMiningCooldown(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `blast_mining` FROM `" + this.tablePrefix + "cooldowns` LIMIT 1");
        }
        catch (SQLException ex) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Blast Mining...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `blast_mining` int(32) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddFishing(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `fishing` FROM `" + this.tablePrefix + "skills` LIMIT 1");
        }
        catch (SQLException ex) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Fishing...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddMobHealthbars(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `mobhealthbar` FROM `" + this.tablePrefix + "huds` LIMIT 1");
        }
        catch (SQLException ex) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for mob healthbars...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "'");
        }
    }

    private void checkUpgradeAddScoreboardTips(Statement statement) throws SQLException {
        try {
            statement.executeQuery("SELECT `scoreboardtips` FROM `" + this.tablePrefix + "huds` LIMIT 1");
        }
        catch (SQLException ex) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for scoreboard tips...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `scoreboardtips` int(10) NOT NULL DEFAULT '0' ;");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddSQLIndexes(Statement statement) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SHOW INDEX FROM `" + this.tablePrefix + "skills` WHERE `Key_name` LIKE 'idx\\_%'");
            resultSet.last();
            if (resultSet.getRow() != SkillType.NON_CHILD_SKILLS.size()) {
                mcMMO.p.getLogger().info("Indexing tables, this may take a while on larger databases");
                for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
                    String skill_name = skill.name().toLowerCase();
                    try {
                        statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_" + skill_name + "` (`" + skill_name + "`) USING BTREE");
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddUUIDs(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("uuid")) continue;
                column_exists = true;
                break;
            }
            if (!column_exists) {
                mcMMO.p.getLogger().info("Adding UUIDs to mcMMO MySQL user table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD `uuid` varchar(36) NULL DEFAULT NULL");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD UNIQUE INDEX `uuid` (`uuid`) USING BTREE");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
        }
        new GetUUIDUpdatesRequired().runTaskLaterAsynchronously((Plugin)mcMMO.p, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropPartyNames(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("party")) continue;
                column_exists = true;
                break;
            }
            if (column_exists) {
                mcMMO.p.getLogger().info("Removing party name from users table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` DROP COLUMN `party`");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropSpout(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "huds` LIMIT 1");
            ResultSetMetaData rsmeta = resultSet.getMetaData();
            boolean column_exists = false;
            for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                if (!rsmeta.getColumnName(i).equalsIgnoreCase("hudtype")) continue;
                column_exists = true;
                break;
            }
            if (column_exists) {
                mcMMO.p.getLogger().info("Removing Spout HUD type from huds table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` DROP COLUMN `hudtype`");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserID(Connection connection, String playerName, UUID uuid) {
        if (uuid != null && this.cachedUserIDs.containsKey(uuid)) {
            return this.cachedUserIDs.get(uuid);
        }
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("SELECT id, user FROM " + this.tablePrefix + "users WHERE uuid = ? OR (uuid IS NULL AND user = ?)");
            statement.setString(1, uuid == null ? null : uuid.toString());
            statement.setString(2, playerName);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int id = resultSet.getInt("id");
                if (uuid != null) {
                    this.cachedUserIDs.put(uuid, id);
                }
                int n = id;
                this.tryClose(resultSet);
                this.tryClose(statement);
                return n;
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        return -1;
    }

    private void tryClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDisable() {
        mcMMO.p.debug("Releasing connection pool resource...");
        this.miscPool.close();
        this.loadPool.close();
        this.savePool.close();
    }

    public static enum PoolIdentifier {
        MISC,
        LOAD,
        SAVE;

    }

    private class GetUUIDUpdatesRequired
    extends BukkitRunnable {
        private GetUUIDUpdatesRequired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SQLDatabaseManager.this.massUpdateLock.lock();
            ArrayList<String> names = new ArrayList<String>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                block10: {
                    try {
                        connection = SQLDatabaseManager.this.miscPool.getConnection();
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery("SELECT `user` FROM `" + SQLDatabaseManager.this.tablePrefix + "users` WHERE `uuid` IS NULL");
                        while (resultSet.next()) {
                            names.add(resultSet.getString("user"));
                        }
                        SQLDatabaseManager.this.tryClose(resultSet);
                    }
                    catch (SQLException ex) {
                        SQLDatabaseManager.this.printErrors(ex);
                        break block10;
                    }
                    finally {
                        SQLDatabaseManager.this.tryClose(resultSet);
                        SQLDatabaseManager.this.tryClose(statement);
                        SQLDatabaseManager.this.tryClose(connection);
                    }
                    SQLDatabaseManager.this.tryClose(statement);
                    SQLDatabaseManager.this.tryClose(connection);
                }
                if (!names.isEmpty()) {
                    new UUIDUpdateAsyncTask(mcMMO.p, names).run();
                }
            }
            finally {
                SQLDatabaseManager.this.massUpdateLock.unlock();
            }
        }
    }
}

