/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.treasure;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Dye;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class TreasureConfig
extends ConfigLoader {
    private static TreasureConfig instance;
    public List<ExcavationTreasure> excavationFromDirt = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromGrass = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromSand = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromGravel = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromClay = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromMycel = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromSoulSand = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromSnow = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromRedSand = new ArrayList<ExcavationTreasure>();
    public List<ExcavationTreasure> excavationFromPodzol = new ArrayList<ExcavationTreasure>();
    public List<HylianTreasure> hylianFromBushes = new ArrayList<HylianTreasure>();
    public List<HylianTreasure> hylianFromFlowers = new ArrayList<HylianTreasure>();
    public List<HylianTreasure> hylianFromPots = new ArrayList<HylianTreasure>();
    public List<ShakeTreasure> shakeFromBlaze = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromCaveSpider = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSpider = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromChicken = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromCow = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromCreeper = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromEnderman = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromGhast = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromHorse = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromIronGolem = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromMagmaCube = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromMushroomCow = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromPig = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromPigZombie = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromPlayer = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSheep = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSkeleton = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSlime = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSnowman = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromSquid = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromWitch = new ArrayList<ShakeTreasure>();
    public List<ShakeTreasure> shakeFromZombie = new ArrayList<ShakeTreasure>();
    public HashMap<Rarity, List<FishingTreasure>> fishingRewards = new HashMap();
    public HashMap<Rarity, List<EnchantmentTreasure>> fishingEnchantments = new HashMap();

    private TreasureConfig() {
        super("treasures.yml");
        this.loadKeys();
        this.validate();
    }

    public static TreasureConfig getInstance() {
        if (instance == null) {
            instance = new TreasureConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        for (String tier : this.config.getConfigurationSection("Enchantment_Drop_Rates").getKeys(false)) {
            double totalEnchantDropRate = 0.0;
            double totalItemDropRate = 0.0;
            for (Rarity rarity : Rarity.values()) {
                double enchantDropRate = this.config.getDouble("Enchantment_Drop_Rates." + tier + "." + rarity.toString());
                double itemDropRate = this.config.getDouble("Item_Drop_Rates." + tier + "." + rarity.toString());
                if ((enchantDropRate < 0.0 || enchantDropRate > 100.0) && rarity != Rarity.TRAP && rarity != Rarity.RECORD) {
                    reason.add("The enchant drop rate for " + tier + " items that are " + rarity.toString() + "should be between 0.0 and 100.0!");
                }
                if (itemDropRate < 0.0 || itemDropRate > 100.0) {
                    reason.add("The item drop rate for " + tier + " items that are " + rarity.toString() + "should be between 0.0 and 100.0!");
                }
                totalEnchantDropRate += enchantDropRate;
                totalItemDropRate += itemDropRate;
            }
            if (totalEnchantDropRate < 0.0 || totalEnchantDropRate > 100.0) {
                reason.add("The total enchant drop rate for " + tier + " should be between 0.0 and 100.0!");
            }
            if (!(totalItemDropRate < 0.0) && !(totalItemDropRate > 100.0)) continue;
            reason.add("The total item drop rate for " + tier + " should be between 0.0 and 100.0!");
        }
        return this.noErrorsInConfig(reason);
    }

    @Override
    protected void loadKeys() {
        if (this.config.getConfigurationSection("Treasures") != null) {
            this.backup();
            return;
        }
        this.loadTreaures("Fishing");
        this.loadTreaures("Excavation");
        this.loadTreaures("Hylian_Luck");
        this.loadEnchantments();
        for (EntityType entity : EntityType.values()) {
            if (!entity.isAlive()) continue;
            this.loadTreaures("Shake." + entity.toString());
        }
    }

    private void loadTreaures(String type) {
        boolean isFishing = type.equals("Fishing");
        boolean isShake = type.contains("Shake");
        boolean isExcavation = type.equals("Excavation");
        boolean isHylian = type.equals("Hylian_Luck");
        ConfigurationSection treasureSection = this.config.getConfigurationSection(type);
        if (treasureSection == null) {
            return;
        }
        for (Rarity rarity : Rarity.values()) {
            if (this.fishingRewards.containsKey((Object)rarity)) continue;
            this.fishingRewards.put(rarity, new ArrayList());
        }
        for (String treasureName : treasureSection.getKeys(false)) {
            List dropList;
            short data;
            Material material;
            ArrayList<String> reason = new ArrayList<String>();
            String[] treasureInfo = treasureName.split("[|]");
            String materialName = treasureInfo[0];
            if (materialName.contains("POTION")) {
                material = Material.POTION;
            } else if (materialName.contains("INK_SACK")) {
                material = Material.INK_SACK;
            } else {
                if (materialName.contains("INVENTORY")) {
                    this.shakeFromPlayer.add(new ShakeTreasure(new ItemStack(Material.BED_BLOCK, 1, 0), 1, this.getInventoryStealDropChance(), this.getInventoryStealDropLevel()));
                    continue;
                }
                material = Material.matchMaterial((String)materialName);
            }
            int amount = this.config.getInt(type + "." + treasureName + ".Amount");
            short s = data = treasureInfo.length == 2 ? Short.parseShort(treasureInfo[1]) : (short)this.config.getInt(type + "." + treasureName + ".Data");
            if (material == null) {
                reason.add("Invalid material: " + materialName);
            }
            if (amount <= 0) {
                reason.add("Amount of " + treasureName + " must be greater than 0! " + amount);
            }
            if (material != null && material.isBlock() && (data > 127 || data < -128)) {
                reason.add("Data of " + treasureName + " is invalid! " + data);
            }
            int xp = this.config.getInt(type + "." + treasureName + ".XP");
            double dropChance = this.config.getDouble(type + "." + treasureName + ".Drop_Chance");
            int dropLevel = this.config.getInt(type + "." + treasureName + ".Drop_Level");
            if (xp < 0) {
                reason.add(treasureName + " has an invalid XP value: " + xp);
            }
            if (dropChance < 0.0) {
                reason.add(treasureName + " has an invalid Drop_Chance: " + dropChance);
            }
            if (dropLevel < 0) {
                reason.add(treasureName + " has an invalid Drop_Level: " + dropLevel);
            }
            Rarity rarity = null;
            if (isFishing && (rarity = Rarity.getRarity(this.config.getString(type + "." + treasureName + ".Rarity"))) == null) {
                reason.add("Invalid Rarity for item: " + treasureName);
            }
            ItemStack item = null;
            if (materialName.contains("POTION")) {
                String potionType = materialName.substring(7);
                try {
                    ItemMeta itemMeta;
                    item = new Potion(PotionType.valueOf((String)potionType.toUpperCase().trim())).toItemStack(amount);
                    if (this.config.contains(type + "." + treasureName + ".Custom_Name")) {
                        itemMeta = item.getItemMeta();
                        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(type + "." + treasureName + ".Custom_Name")));
                        item.setItemMeta(itemMeta);
                    }
                    if (this.config.contains(type + "." + treasureName + ".Lore")) {
                        itemMeta = item.getItemMeta();
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String s2 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s2));
                        }
                        itemMeta.setLore(lore);
                        item.setItemMeta(itemMeta);
                    }
                }
                catch (IllegalArgumentException ex) {
                    reason.add("Invalid Potion_Type: " + potionType);
                }
            } else if (materialName.contains("INK_SACK")) {
                String color = materialName.substring(9);
                try {
                    ItemMeta itemMeta;
                    Dye dye = new Dye();
                    dye.setColor(DyeColor.valueOf((String)color.toUpperCase().trim()));
                    item = dye.toItemStack(amount);
                    if (this.config.contains(type + "." + treasureName + ".Custom_Name")) {
                        itemMeta = item.getItemMeta();
                        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(type + "." + treasureName + ".Custom_Name")));
                        item.setItemMeta(itemMeta);
                    }
                    if (this.config.contains(type + "." + treasureName + ".Lore")) {
                        itemMeta = item.getItemMeta();
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String s3 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s3));
                        }
                        itemMeta.setLore(lore);
                        item.setItemMeta(itemMeta);
                    }
                }
                catch (IllegalArgumentException ex) {
                    reason.add("Invalid Dye_Color: " + color);
                }
            } else if (material != null) {
                ItemMeta itemMeta;
                item = new ItemStack(material, amount, data);
                if (this.config.contains(type + "." + treasureName + ".Custom_Name")) {
                    itemMeta = item.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(type + "." + treasureName + ".Custom_Name")));
                    item.setItemMeta(itemMeta);
                }
                if (this.config.contains(type + "." + treasureName + ".Lore")) {
                    itemMeta = item.getItemMeta();
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String s4 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s4));
                    }
                    itemMeta.setLore(lore);
                    item.setItemMeta(itemMeta);
                }
            }
            if (!this.noErrorsInConfig(reason)) continue;
            if (isFishing) {
                this.fishingRewards.get((Object)rarity).add(new FishingTreasure(item, xp));
                continue;
            }
            if (isShake) {
                ShakeTreasure shakeTreasure = new ShakeTreasure(item, xp, dropChance, dropLevel);
                if (type.equals("Shake.BLAZE")) {
                    this.shakeFromBlaze.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.CAVE_SPIDER")) {
                    this.shakeFromCaveSpider.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.CHICKEN")) {
                    this.shakeFromChicken.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.COW")) {
                    this.shakeFromCow.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.CREEPER")) {
                    this.shakeFromCreeper.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.ENDERMAN")) {
                    this.shakeFromEnderman.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.GHAST")) {
                    this.shakeFromGhast.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.HORSE")) {
                    this.shakeFromHorse.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.IRON_GOLEM")) {
                    this.shakeFromIronGolem.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.MAGMA_CUBE")) {
                    this.shakeFromMagmaCube.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.MUSHROOM_COW")) {
                    this.shakeFromMushroomCow.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.PIG")) {
                    this.shakeFromPig.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.PIG_ZOMBIE")) {
                    this.shakeFromPigZombie.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.PLAYER")) {
                    this.shakeFromPlayer.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SHEEP")) {
                    this.shakeFromSheep.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SKELETON")) {
                    this.shakeFromSkeleton.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SLIME")) {
                    this.shakeFromSlime.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SPIDER")) {
                    this.shakeFromSpider.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SNOWMAN")) {
                    this.shakeFromSnowman.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.SQUID")) {
                    this.shakeFromSquid.add(shakeTreasure);
                    continue;
                }
                if (type.equals("Shake.WITCH")) {
                    this.shakeFromWitch.add(shakeTreasure);
                    continue;
                }
                if (!type.equals("Shake.ZOMBIE")) continue;
                this.shakeFromZombie.add(shakeTreasure);
                continue;
            }
            if (isExcavation) {
                ExcavationTreasure excavationTreasure = new ExcavationTreasure(item, xp, dropChance, dropLevel);
                dropList = this.config.getStringList(type + "." + treasureName + ".Drops_From");
                if (dropList.contains("Dirt")) {
                    this.excavationFromDirt.add(excavationTreasure);
                }
                if (dropList.contains("Grass")) {
                    this.excavationFromGrass.add(excavationTreasure);
                }
                if (dropList.contains("Sand")) {
                    this.excavationFromSand.add(excavationTreasure);
                }
                if (dropList.contains("Gravel")) {
                    this.excavationFromGravel.add(excavationTreasure);
                }
                if (dropList.contains("Clay")) {
                    this.excavationFromClay.add(excavationTreasure);
                }
                if (dropList.contains("Mycelium")) {
                    this.excavationFromMycel.add(excavationTreasure);
                }
                if (dropList.contains("Soul_Sand")) {
                    this.excavationFromSoulSand.add(excavationTreasure);
                }
                if (dropList.contains("Snow")) {
                    this.excavationFromSnow.add(excavationTreasure);
                }
                if (dropList.contains("Red_Sand")) {
                    this.excavationFromRedSand.add(excavationTreasure);
                }
                if (!dropList.contains("Podzol")) continue;
                this.excavationFromPodzol.add(excavationTreasure);
                continue;
            }
            if (!isHylian) continue;
            HylianTreasure hylianTreasure = new HylianTreasure(item, xp, dropChance, dropLevel);
            dropList = this.config.getStringList(type + "." + treasureName + ".Drops_From");
            if (dropList.contains("Bushes")) {
                this.hylianFromBushes.add(hylianTreasure);
            }
            if (dropList.contains("Flowers")) {
                this.hylianFromFlowers.add(hylianTreasure);
            }
            if (!dropList.contains("Pots")) continue;
            this.hylianFromPots.add(hylianTreasure);
        }
    }

    private void loadEnchantments() {
        for (Rarity rarity : Rarity.values()) {
            ConfigurationSection enchantmentSection;
            if (rarity == Rarity.TRAP || rarity == Rarity.RECORD) continue;
            if (!this.fishingEnchantments.containsKey((Object)rarity)) {
                this.fishingEnchantments.put(rarity, new ArrayList());
            }
            if ((enchantmentSection = this.config.getConfigurationSection("Enchantments_Rarity." + rarity.toString())) == null) {
                return;
            }
            for (String enchantmentName : enchantmentSection.getKeys(false)) {
                int level = this.config.getInt("Enchantments_Rarity." + rarity.toString() + "." + enchantmentName);
                Enchantment enchantment = EnchantmentUtils.getByName(enchantmentName);
                if (enchantment == null) {
                    plugin.getLogger().warning("Skipping invalid enchantment in treasures.yml: " + enchantmentName);
                    continue;
                }
                this.fishingEnchantments.get((Object)rarity).add(new EnchantmentTreasure(enchantment, level));
            }
        }
    }

    public boolean getInventoryStealEnabled() {
        return this.config.contains("Shake.PLAYER.INVENTORY");
    }

    public boolean getInventoryStealStacks() {
        return this.config.getBoolean("Shake.PLAYER.INVENTORY.Whole_Stacks");
    }

    public double getInventoryStealDropChance() {
        return this.config.getDouble("Shake.PLAYER.INVENTORY.Drop_Chance");
    }

    public int getInventoryStealDropLevel() {
        return this.config.getInt("Shake.PLAYER.INVENTORY.Drop_Level");
    }

    public double getItemDropRate(int tier, Rarity rarity) {
        return this.config.getDouble("Item_Drop_Rates.Tier_" + tier + "." + rarity.toString());
    }

    public double getEnchantmentDropRate(int tier, Rarity rarity) {
        return this.config.getDouble("Enchantment_Drop_Rates.Tier_" + tier + "." + rarity.toString());
    }
}

