/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.alchemy;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionConfig
extends ConfigLoader {
    private static PotionConfig instance;
    private List<ItemStack> concoctionsIngredientsTierOne = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierTwo = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierThree = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierFour = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierFive = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierSix = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierSeven = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierEight = new ArrayList<ItemStack>();
    private Map<Short, AlchemyPotion> potionMap = new HashMap<Short, AlchemyPotion>();

    private PotionConfig() {
        super("potions.yml");
        this.loadKeys();
    }

    public static PotionConfig getInstance() {
        if (instance == null) {
            instance = new PotionConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
        this.loadConcoctions();
        this.loadPotionMap();
    }

    private void loadConcoctions() {
        ConfigurationSection concoctionSection = this.config.getConfigurationSection("Concoctions");
        this.loadConcoctionsTier(this.concoctionsIngredientsTierOne, concoctionSection.getStringList("Tier_One_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierTwo, concoctionSection.getStringList("Tier_Two_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierThree, concoctionSection.getStringList("Tier_Three_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFour, concoctionSection.getStringList("Tier_Four_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFive, concoctionSection.getStringList("Tier_Five_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSix, concoctionSection.getStringList("Tier_Six_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSeven, concoctionSection.getStringList("Tier_Seven_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierEight, concoctionSection.getStringList("Tier_Eight_Ingredients"));
        this.concoctionsIngredientsTierTwo.addAll(this.concoctionsIngredientsTierOne);
        this.concoctionsIngredientsTierThree.addAll(this.concoctionsIngredientsTierTwo);
        this.concoctionsIngredientsTierFour.addAll(this.concoctionsIngredientsTierThree);
        this.concoctionsIngredientsTierFive.addAll(this.concoctionsIngredientsTierFour);
        this.concoctionsIngredientsTierSix.addAll(this.concoctionsIngredientsTierFive);
        this.concoctionsIngredientsTierSeven.addAll(this.concoctionsIngredientsTierSix);
        this.concoctionsIngredientsTierEight.addAll(this.concoctionsIngredientsTierSeven);
    }

    private void loadConcoctionsTier(List<ItemStack> ingredientList, List<String> ingredientStrings) {
        if (ingredientStrings != null && ingredientStrings.size() > 0) {
            for (String ingredientString : ingredientStrings) {
                ItemStack ingredient = this.loadIngredient(ingredientString);
                if (ingredient == null) continue;
                ingredientList.add(ingredient);
            }
        }
    }

    private void loadPotionMap() {
        ConfigurationSection potionSection = this.config.getConfigurationSection("Potions");
        int pass = 0;
        int fail = 0;
        for (String dataValue : potionSection.getKeys(false)) {
            AlchemyPotion potion = this.loadPotion(potionSection.getConfigurationSection(dataValue));
            if (potion != null) {
                this.potionMap.put(potion.getDataValue(), potion);
                ++pass;
                continue;
            }
            ++fail;
        }
        mcMMO.p.debug("Loaded " + pass + " Alchemy potions, skipped " + fail + ".");
    }

    private AlchemyPotion loadPotion(ConfigurationSection potion_section) {
        try {
            short dataValue = Short.parseShort(potion_section.getName());
            String name = potion_section.getString("Name");
            if (name != null) {
                name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            }
            ArrayList<String> lore = new ArrayList<String>();
            if (potion_section.contains("Lore")) {
                for (Object line : potion_section.getStringList("Lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
            }
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            if (potion_section.contains("Effects")) {
                for (String effect : potion_section.getStringList("Effects")) {
                    int duration;
                    String[] parts = effect.split(" ");
                    PotionEffectType type = parts.length > 0 ? PotionEffectType.getByName((String)parts[0]) : null;
                    int amplifier = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                    int n = duration = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
                    if (type != null) {
                        effects.add(new PotionEffect(type, duration, amplifier));
                        continue;
                    }
                    mcMMO.p.getLogger().warning("Failed to parse effect for potion " + name + ": " + effect);
                }
            }
            HashMap<ItemStack, Short> children = new HashMap<ItemStack, Short>();
            if (potion_section.contains("Children")) {
                for (String child : potion_section.getConfigurationSection("Children").getKeys(false)) {
                    ItemStack ingredient = this.loadIngredient(child);
                    if (ingredient != null) {
                        children.put(ingredient, Short.parseShort(potion_section.getConfigurationSection("Children").getString(child)));
                        continue;
                    }
                    mcMMO.p.getLogger().warning("Failed to parse child for potion " + name + ": " + child);
                }
            }
            return new AlchemyPotion(dataValue, name, lore, effects, children);
        }
        catch (Exception e) {
            mcMMO.p.getLogger().warning("Failed to load Alchemy potion: " + potion_section.getName());
            return null;
        }
    }

    private ItemStack loadIngredient(String ingredient) {
        short data;
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        String[] parts = ingredient.split(":");
        Material material = parts.length > 0 ? Material.getMaterial((String)parts[0]) : null;
        short s = data = parts.length > 1 ? Short.parseShort(parts[1]) : (short)0;
        if (material != null) {
            return new ItemStack(material, 1, data);
        }
        return null;
    }

    public List<ItemStack> getIngredients(int tier) {
        switch (tier) {
            case 8: {
                return this.concoctionsIngredientsTierEight;
            }
            case 7: {
                return this.concoctionsIngredientsTierSeven;
            }
            case 6: {
                return this.concoctionsIngredientsTierSix;
            }
            case 5: {
                return this.concoctionsIngredientsTierFive;
            }
            case 4: {
                return this.concoctionsIngredientsTierFour;
            }
            case 3: {
                return this.concoctionsIngredientsTierThree;
            }
            case 2: {
                return this.concoctionsIngredientsTierTwo;
            }
        }
        return this.concoctionsIngredientsTierOne;
    }

    public boolean isValidPotion(ItemStack item) {
        return this.potionMap.containsKey(item.getDurability());
    }

    public AlchemyPotion getPotion(short durability) {
        return this.potionMap.get(durability);
    }
}

