/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party.teleport;

import com.gmail.nossr50.commands.party.teleport.PtpAcceptAnyCommand;
import com.gmail.nossr50.commands.party.teleport.PtpAcceptCommand;
import com.gmail.nossr50.commands.party.teleport.PtpToggleCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.items.TeleportationWarmup;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class PtpCommand
implements TabExecutor {
    public static final List<String> TELEPORT_SUBCOMMANDS = ImmutableList.of((Object)"toggle", (Object)"accept", (Object)"acceptany", (Object)"acceptall");
    private CommandExecutor ptpToggleCommand = new PtpToggleCommand();
    private CommandExecutor ptpAcceptAnyCommand = new PtpAcceptAnyCommand();
    private CommandExecutor ptpAcceptCommand = new PtpAcceptCommand();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (CommandUtils.noConsoleUsage(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return true;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (!mcMMOPlayer.inParty()) {
            sender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return true;
        }
        Party party = mcMMOPlayer.getParty();
        if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.TELEPORT)) {
            sender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.2"));
            return true;
        }
        switch (args.length) {
            case 1: {
                int timeRemaining;
                int timeRemaining2;
                if (args[0].equalsIgnoreCase("toggle")) {
                    return this.ptpToggleCommand.onCommand(sender, command, label, args);
                }
                if (args[0].equalsIgnoreCase("acceptany") || args[0].equalsIgnoreCase("acceptall")) {
                    return this.ptpAcceptAnyCommand.onCommand(sender, command, label, args);
                }
                long recentlyHurt = mcMMOPlayer.getRecentlyHurt();
                int hurtCooldown = Config.getInstance().getPTPCommandRecentlyHurtCooldown();
                if (hurtCooldown > 0 && (timeRemaining2 = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, player)) > 0) {
                    player.sendMessage(LocaleLoader.getString("Item.Injured.Wait", timeRemaining2));
                    return true;
                }
                if (args[0].equalsIgnoreCase("accept")) {
                    return this.ptpAcceptCommand.onCommand(sender, command, label, args);
                }
                if (!Permissions.partyTeleportSend((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                int ptpCooldown = Config.getInstance().getPTPCommandCooldown();
                long ptpLastUse = mcMMOPlayer.getPartyTeleportRecord().getLastUse();
                if (ptpCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(ptpLastUse * 1000L, ptpCooldown, player)) > 0) {
                    player.sendMessage(LocaleLoader.getString("Item.Generic.Wait", timeRemaining));
                    return true;
                }
                this.sendTeleportRequest(sender, player, CommandUtils.getMatchedPlayerName(args[0]));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List matches = (List)StringUtil.copyPartialMatches((String)args[0], TELEPORT_SUBCOMMANDS, new ArrayList(TELEPORT_SUBCOMMANDS.size()));
                if (matches.size() == 0) {
                    Player player = (Player)sender;
                    McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                    if (!mcMMOPlayer.inParty()) {
                        return ImmutableList.of();
                    }
                    List<String> playerNames = mcMMOPlayer.getParty().getOnlinePlayerNames((CommandSender)player);
                    return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
                }
                return matches;
            }
        }
        return ImmutableList.of();
    }

    private void sendTeleportRequest(CommandSender sender, Player player, String targetName) {
        if (!PtpCommand.canTeleport(sender, player, targetName)) {
            return;
        }
        McMMOPlayer mcMMOTarget = UserManager.getPlayer(targetName);
        Player target = mcMMOTarget.getPlayer();
        PartyTeleportRecord ptpRecord = mcMMOTarget.getPartyTeleportRecord();
        if (!ptpRecord.isConfirmRequired()) {
            PtpCommand.handleTeleportWarmup(player, target);
            return;
        }
        ptpRecord.setRequestor(player);
        ptpRecord.actualizeTimeout();
        player.sendMessage(LocaleLoader.getString("Commands.Invite.Success"));
        target.sendMessage(LocaleLoader.getString("Commands.ptp.Request1", player.getName()));
        target.sendMessage(LocaleLoader.getString("Commands.ptp.Request2", Config.getInstance().getPTPCommandTimeout()));
    }

    protected static boolean canTeleport(CommandSender sender, Player player, String targetName) {
        McMMOPlayer mcMMOTarget = UserManager.getPlayer(targetName);
        if (!CommandUtils.checkPlayerExistence(sender, targetName, mcMMOTarget)) {
            return false;
        }
        Player target = mcMMOTarget.getPlayer();
        if (player.equals(target)) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Self"));
            return false;
        }
        if (!PartyManager.inSameParty(player, target)) {
            player.sendMessage(LocaleLoader.getString("Party.NotInYourParty", targetName));
            return false;
        }
        if (!mcMMOTarget.getPartyTeleportRecord().isEnabled()) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Disabled", targetName));
            return false;
        }
        if (!target.isValid()) {
            player.sendMessage(LocaleLoader.getString("Party.Teleport.Dead"));
            return false;
        }
        return true;
    }

    protected static void handleTeleportWarmup(Player teleportingPlayer, Player targetPlayer) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(teleportingPlayer);
        McMMOPlayer mcMMOTarget = UserManager.getPlayer(targetPlayer);
        long warmup = Config.getInstance().getPTPCommandWarmup();
        mcMMOPlayer.actualizeTeleportCommenceLocation(teleportingPlayer);
        if (warmup > 0L) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Teleport.Commencing", warmup));
            new TeleportationWarmup(mcMMOPlayer, mcMMOTarget).runTaskLater((Plugin)mcMMO.p, 20L * warmup);
        } else {
            EventUtils.handlePartyTeleportEvent(teleportingPlayer, targetPlayer);
        }
    }
}

