/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.glow;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.apihelper.API;
import org.inventivetalent.apihelper.APIManager;
import org.inventivetalent.glow.GlowData;
import org.inventivetalent.glow.GlowPlugin;
import org.inventivetalent.glow.reflection.minecraft.DataWatcher;
import org.inventivetalent.glow.reflection.minecraft.Minecraft;
import org.inventivetalent.glow.reflection.resolver.ConstructorResolver;
import org.inventivetalent.glow.reflection.resolver.FieldResolver;
import org.inventivetalent.glow.reflection.resolver.MethodResolver;
import org.inventivetalent.glow.reflection.resolver.ResolverQuery;
import org.inventivetalent.glow.reflection.resolver.minecraft.NMSClassResolver;
import org.inventivetalent.glow.reflection.resolver.minecraft.OBCClassResolver;
import org.inventivetalent.packetlistener.PacketListenerAPI;
import org.inventivetalent.packetlistener.handler.PacketHandler;
import org.inventivetalent.packetlistener.handler.PacketOptions;
import org.inventivetalent.packetlistener.handler.ReceivedPacket;
import org.inventivetalent.packetlistener.handler.SentPacket;

public class GlowAPI
implements API,
Listener {
    private static Map<UUID, GlowData> dataMap = new HashMap<UUID, GlowData>();
    private static final NMSClassResolver NMS_CLASS_RESOLVER = new NMSClassResolver();
    private static Class<?> PacketPlayOutEntityMetadata;
    static Class<?> DataWatcher;
    static Class<?> DataWatcherItem;
    private static Class<?> Entity;
    private static FieldResolver PacketPlayOutMetadataFieldResolver;
    private static FieldResolver EntityFieldResolver;
    private static FieldResolver DataWatcherFieldResolver;
    static FieldResolver DataWatcherItemFieldResolver;
    private static ConstructorResolver DataWatcherItemConstructorResolver;
    private static MethodResolver DataWatcherMethodResolver;
    static MethodResolver DataWatcherItemMethodResolver;
    private static MethodResolver EntityMethodResolver;
    private static Class<?> PacketPlayOutScoreboardTeam;
    private static FieldResolver PacketScoreboardTeamFieldResolver;
    private static FieldResolver EntityPlayerFieldResolver;
    private static MethodResolver PlayerConnectionMethodResolver;
    public static String TEAM_TAG_VISIBILITY;
    public static String TEAM_PUSH;
    protected static NMSClassResolver nmsClassResolver;
    protected static OBCClassResolver obcClassResolver;
    private static FieldResolver CraftWorldFieldResolver;
    private static FieldResolver WorldFieldResolver;
    private static MethodResolver IntHashMapMethodResolver;

    public static void setGlowing(Entity entity, Color color, String tagVisibility, String push, Player receiver) {
        Color oldColor;
        boolean glowing;
        if (receiver == null) {
            return;
        }
        boolean bl = glowing = color != null;
        if (entity == null) {
            glowing = false;
        }
        if (entity instanceof OfflinePlayer && !((OfflinePlayer)entity).isOnline()) {
            glowing = false;
        }
        boolean wasGlowing = dataMap.containsKey(entity != null ? entity.getUniqueId() : null);
        GlowData glowData = wasGlowing && entity != null ? dataMap.get(entity.getUniqueId()) : new GlowData();
        Color color2 = oldColor = wasGlowing ? glowData.colorMap.get(receiver.getUniqueId()) : null;
        if (glowing) {
            glowData.colorMap.put(receiver.getUniqueId(), color);
        } else {
            glowData.colorMap.remove(receiver.getUniqueId());
        }
        if (glowData.colorMap.isEmpty()) {
            dataMap.remove(entity != null ? entity.getUniqueId() : null);
        } else if (entity != null) {
            dataMap.put(entity.getUniqueId(), glowData);
        }
        if (color != null && oldColor == color) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (entity instanceof OfflinePlayer && !((OfflinePlayer)entity).isOnline()) {
            return;
        }
        if (!receiver.isOnline()) {
            return;
        }
        GlowAPI.sendGlowPacket(entity, wasGlowing, glowing, receiver);
        if (oldColor != null && oldColor != Color.NONE) {
            GlowAPI.sendTeamPacket(entity, oldColor, false, false, tagVisibility, push, receiver);
        }
        if (glowing) {
            GlowAPI.sendTeamPacket(entity, color, false, color != Color.NONE, tagVisibility, push, receiver);
        }
    }

    public static void setGlowing(Entity entity, Color color, Player receiver) {
        GlowAPI.setGlowing(entity, color, "always", "always", receiver);
    }

    public static void setGlowing(Entity entity, boolean glowing, Player receiver) {
        GlowAPI.setGlowing(entity, glowing ? Color.NONE : null, receiver);
    }

    public static void setGlowing(Entity entity, boolean glowing, Collection<? extends Player> receivers) {
        for (Player player : receivers) {
            GlowAPI.setGlowing(entity, glowing, player);
        }
    }

    public static void setGlowing(Entity entity, Color color, Collection<? extends Player> receivers) {
        for (Player player : receivers) {
            GlowAPI.setGlowing(entity, color, player);
        }
    }

    public static void setGlowing(Collection<? extends Entity> entities, Color color, Player receiver) {
        for (Entity entity : entities) {
            GlowAPI.setGlowing(entity, color, receiver);
        }
    }

    public static void setGlowing(Collection<? extends Entity> entities, Color color, Collection<? extends Player> receivers) {
        for (Entity entity : entities) {
            GlowAPI.setGlowing(entity, color, receivers);
        }
    }

    public static boolean isGlowing(Entity entity, Player receiver) {
        return GlowAPI.getGlowColor(entity, receiver) != null;
    }

    public static boolean isGlowing(Entity entity, Collection<? extends Player> receivers, boolean checkAll) {
        if (checkAll) {
            boolean glowing = true;
            for (Player player : receivers) {
                if (GlowAPI.isGlowing(entity, player)) continue;
                glowing = false;
            }
            return glowing;
        }
        for (Player player : receivers) {
            if (!GlowAPI.isGlowing(entity, player)) continue;
            return true;
        }
        return false;
    }

    public static Color getGlowColor(Entity entity, Player receiver) {
        if (!dataMap.containsKey(entity.getUniqueId())) {
            return null;
        }
        GlowData data = dataMap.get(entity.getUniqueId());
        return data.colorMap.get(receiver.getUniqueId());
    }

    protected static void sendGlowPacket(Entity entity, boolean wasGlowing, boolean glowing, Player receiver) {
        try {
            if (PacketPlayOutEntityMetadata == null) {
                PacketPlayOutEntityMetadata = NMS_CLASS_RESOLVER.resolve("PacketPlayOutEntityMetadata");
            }
            if (DataWatcher == null) {
                DataWatcher = NMS_CLASS_RESOLVER.resolve("DataWatcher");
            }
            if (DataWatcherItem == null) {
                DataWatcherItem = NMS_CLASS_RESOLVER.resolve("DataWatcher$Item");
            }
            if (Entity == null) {
                Entity = NMS_CLASS_RESOLVER.resolve("Entity");
            }
            if (PacketPlayOutMetadataFieldResolver == null) {
                PacketPlayOutMetadataFieldResolver = new FieldResolver(PacketPlayOutEntityMetadata);
            }
            if (DataWatcherItemConstructorResolver == null) {
                DataWatcherItemConstructorResolver = new ConstructorResolver(DataWatcherItem);
            }
            if (EntityFieldResolver == null) {
                EntityFieldResolver = new FieldResolver(Entity);
            }
            if (DataWatcherMethodResolver == null) {
                DataWatcherMethodResolver = new MethodResolver(DataWatcher);
            }
            if (DataWatcherItemMethodResolver == null) {
                DataWatcherItemMethodResolver = new MethodResolver(DataWatcherItem);
            }
            if (EntityMethodResolver == null) {
                EntityMethodResolver = new MethodResolver(Entity);
            }
            if (DataWatcherFieldResolver == null) {
                DataWatcherFieldResolver = new FieldResolver(DataWatcher);
            }
            ArrayList list = new ArrayList();
            Object dataWatcher = EntityMethodResolver.resolve("getDataWatcher").invoke(Minecraft.getHandle(entity), new Object[0]);
            Map dataWatcherItems = (Map)DataWatcherFieldResolver.resolveByLastType(Map.class).get(dataWatcher);
            Object dataWatcherObject = DataWatcher.V1_9.ValueType.ENTITY_FLAG.getType();
            byte prev = (Byte)(dataWatcherItems.isEmpty() ? Integer.valueOf(0) : DataWatcherItemMethodResolver.resolve("b").invoke(dataWatcherItems.get(0), new Object[0]));
            byte b = (byte)(glowing ? prev | 0x40 : prev & 0xFFFFFFBF);
            Object dataWatcherItem = DataWatcherItemConstructorResolver.resolveFirstConstructor().newInstance(dataWatcherObject, b);
            list.add(dataWatcherItem);
            Object packetMetadata = PacketPlayOutEntityMetadata.newInstance();
            PacketPlayOutMetadataFieldResolver.resolve("a").set(packetMetadata, -entity.getEntityId());
            PacketPlayOutMetadataFieldResolver.resolve("b").set(packetMetadata, list);
            GlowAPI.sendPacket(packetMetadata, receiver);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initTeam(Player receiver, String tagVisibility, String push) {
        for (Color color : Color.values()) {
            GlowAPI.sendTeamPacket(null, color, true, false, tagVisibility, push, receiver);
        }
    }

    public static void initTeam(Player receiver) {
        GlowAPI.initTeam(receiver, TEAM_TAG_VISIBILITY, TEAM_PUSH);
    }

    protected static void sendTeamPacket(Entity entity, Color color, boolean createNewTeam, boolean addEntity, String tagVisibility, String push, Player receiver) {
        try {
            if (PacketPlayOutScoreboardTeam == null) {
                PacketPlayOutScoreboardTeam = NMS_CLASS_RESOLVER.resolve("PacketPlayOutScoreboardTeam");
            }
            if (PacketScoreboardTeamFieldResolver == null) {
                PacketScoreboardTeamFieldResolver = new FieldResolver(PacketPlayOutScoreboardTeam);
            }
            Object packetScoreboardTeam = PacketPlayOutScoreboardTeam.newInstance();
            PacketScoreboardTeamFieldResolver.resolve("i").set(packetScoreboardTeam, createNewTeam ? 0 : (addEntity ? 3 : 4));
            PacketScoreboardTeamFieldResolver.resolve("a").set(packetScoreboardTeam, color.getTeamName());
            PacketScoreboardTeamFieldResolver.resolve("e").set(packetScoreboardTeam, tagVisibility);
            PacketScoreboardTeamFieldResolver.resolve("f").set(packetScoreboardTeam, push);
            if (createNewTeam) {
                PacketScoreboardTeamFieldResolver.resolve("g").set(packetScoreboardTeam, color.packetValue);
                PacketScoreboardTeamFieldResolver.resolve("c").set(packetScoreboardTeam, "\u00a7" + color.colorCode);
                PacketScoreboardTeamFieldResolver.resolve("b").set(packetScoreboardTeam, color.getTeamName());
                PacketScoreboardTeamFieldResolver.resolve("d").set(packetScoreboardTeam, "");
                PacketScoreboardTeamFieldResolver.resolve("j").set(packetScoreboardTeam, 0);
            }
            if (!createNewTeam) {
                Collection collection = (Collection)PacketScoreboardTeamFieldResolver.resolve("h").get(packetScoreboardTeam);
                if (entity instanceof OfflinePlayer) {
                    collection.add(entity.getName());
                } else {
                    collection.add(entity.getUniqueId().toString());
                }
            }
            GlowAPI.sendPacket(packetScoreboardTeam, receiver);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void sendPacket(Object packet, Player p) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        if (EntityPlayerFieldResolver == null) {
            EntityPlayerFieldResolver = new FieldResolver(NMS_CLASS_RESOLVER.resolve("EntityPlayer"));
        }
        if (PlayerConnectionMethodResolver == null) {
            PlayerConnectionMethodResolver = new MethodResolver(NMS_CLASS_RESOLVER.resolve("PlayerConnection"));
        }
        try {
            Object handle = Minecraft.getHandle(p);
            Object connection = EntityPlayerFieldResolver.resolve("playerConnection").get(handle);
            PlayerConnectionMethodResolver.resolve("sendPacket").invoke(connection, packet);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void load() {
        APIManager.require(PacketListenerAPI.class, (Plugin)GlowPlugin.instance);
    }

    @Override
    public void init(Plugin plugin) {
        APIManager.initAPI(PacketListenerAPI.class);
        APIManager.registerEvents(this, this);
        PacketHandler.addHandler((PacketHandler)new PacketHandler((Plugin)(GlowPlugin.instance != null ? GlowPlugin.instance : plugin)){

            @PacketOptions(forcePlayer=true)
            public void onSend(SentPacket sentPacket) {
                if ("PacketPlayOutEntityMetadata".equals(sentPacket.getPacketName())) {
                    int a = (Integer)sentPacket.getPacketValue("a");
                    if (a < 0) {
                        sentPacket.setPacketValue("a", (Object)(-a));
                        return;
                    }
                    List b = (List)sentPacket.getPacketValue("b");
                    if (b == null || b.isEmpty()) {
                        return;
                    }
                    Entity entity = GlowAPI.getEntityById(sentPacket.getPlayer().getWorld(), a);
                    if (entity != null && GlowAPI.isGlowing(entity, sentPacket.getPlayer())) {
                        if (DataWatcherItemMethodResolver == null) {
                            DataWatcherItemMethodResolver = new MethodResolver(DataWatcherItem);
                        }
                        if (DataWatcherItemFieldResolver == null) {
                            DataWatcherItemFieldResolver = new FieldResolver(DataWatcherItem);
                        }
                        try {
                            Object prevItem = b.get(0);
                            Object prevObj = DataWatcherItemMethodResolver.resolve("b").invoke(prevItem, new Object[0]);
                            if (prevObj instanceof Byte) {
                                byte prev = (Byte)prevObj;
                                byte bte = (byte)(prev | 0x40);
                                DataWatcherItemFieldResolver.resolve("b").set(prevItem, bte);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            public void onReceive(ReceivedPacket receivedPacket) {
            }
        });
    }

    @Override
    public void disable(Plugin plugin) {
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        GlowAPI.initTeam(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        for (Player receiver : Bukkit.getOnlinePlayers()) {
            if (!GlowAPI.isGlowing((Entity)event.getPlayer(), receiver)) continue;
            GlowAPI.setGlowing((Entity)event.getPlayer(), null, receiver);
        }
    }

    public static Entity getEntityById(World world, int entityId) {
        try {
            if (CraftWorldFieldResolver == null) {
                CraftWorldFieldResolver = new FieldResolver(obcClassResolver.resolve("CraftWorld"));
            }
            if (WorldFieldResolver == null) {
                WorldFieldResolver = new FieldResolver(nmsClassResolver.resolve("World"));
            }
            if (IntHashMapMethodResolver == null) {
                IntHashMapMethodResolver = new MethodResolver(nmsClassResolver.resolve("IntHashMap"));
            }
            if (EntityMethodResolver == null) {
                EntityMethodResolver = new MethodResolver(nmsClassResolver.resolve("Entity"));
            }
            Object entitiesById = WorldFieldResolver.resolve("entitiesById").get(CraftWorldFieldResolver.resolve("world").get(world));
            Object entity = IntHashMapMethodResolver.resolve(new ResolverQuery("get", Integer.TYPE)).invoke(entitiesById, entityId);
            if (entity == null) {
                return null;
            }
            return (Entity)EntityMethodResolver.resolve("getBukkitEntity").invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        TEAM_TAG_VISIBILITY = "always";
        TEAM_PUSH = "always";
        nmsClassResolver = new NMSClassResolver();
        obcClassResolver = new OBCClassResolver();
    }

    public static enum Color {
        BLACK(0, "0"),
        DARK_BLUE(1, "1"),
        DARK_GREEN(2, "2"),
        DARK_AQUA(3, "3"),
        DARK_RED(4, "4"),
        DARK_PURPLE(5, "5"),
        GOLD(6, "6"),
        GRAY(7, "7"),
        DARK_GRAY(8, "8"),
        BLUE(9, "9"),
        GREEN(10, "a"),
        AQUA(11, "b"),
        RED(12, "c"),
        PURPLE(13, "d"),
        YELLOW(14, "e"),
        WHITE(15, "f"),
        NONE(-1, "");

        int packetValue;
        String colorCode;

        private Color(int packetValue, String colorCode) {
            this.packetValue = packetValue;
            this.colorCode = colorCode;
        }

        String getTeamName() {
            String name = String.format("GAPI#%s", this.name());
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            return name;
        }
    }
}

