/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi.updater;

import java.util.regex.Matcher;
import ru.beykerykt.lightapi.updater.Updater;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version parse(String version) {
        Matcher matcher = Updater.regex.matcher(version);
        if (matcher.matches()) {
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            return new Version(x, y, z);
        }
        return null;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.patch;
    }

    public boolean compare(Version version) {
        int result = version.getMajor() - this.getMajor();
        if (result == 0 && (result = version.getMinor() - this.getMinor()) == 0) {
            result = version.getPatch() - this.getPatch();
        }
        return result > 0;
    }
}

