/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi.server.nms.craftbukkit;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.Chunk;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.EnumSkyBlock;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutMapChunk;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import ru.beykerykt.lightapi.chunks.ChunkInfo;
import ru.beykerykt.lightapi.server.nms.INMSHandler;

public class CraftBukkit_v1_10_R1
implements INMSHandler {
    private static Field cachedChunkModified;

    @Override
    public void createLight(World world, int x, int y, int z, int light) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        BlockPosition position = new BlockPosition(x, y, z);
        worldServer.a(EnumSkyBlock.BLOCK, position, light);
    }

    @Override
    public void deleteLight(World world, int x, int y, int z) {
        this.recalculateLight(world, x, y, z);
    }

    @Override
    public void recalculateLight(World world, int x, int y, int z) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        BlockPosition position = new BlockPosition(x, y, z);
        worldServer.c(EnumSkyBlock.BLOCK, position);
    }

    @Override
    public List<ChunkInfo> collectChunks(World world, int x, int y, int z) {
        CopyOnWriteArrayList<ChunkInfo> list = new CopyOnWriteArrayList<ChunkInfo>();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        try {
            WorldServer nmsWorld = ((CraftWorld)world).getHandle();
            int dX = -1;
            while (dX <= 1) {
                int dZ = -1;
                while (dZ <= 1) {
                    Chunk chunk;
                    Field isModified;
                    if (nmsWorld.getChunkProviderServer().isLoaded(chunkX + dX, chunkZ + dZ) && (isModified = CraftBukkit_v1_10_R1.getChunkField(chunk = nmsWorld.getChunkAt(chunkX + dX, chunkZ + dZ))).getBoolean(chunk)) {
                        ChunkInfo cCoord = new ChunkInfo(world, chunk.locX, y, chunk.locZ, world.getPlayers());
                        list.add(cCoord);
                        chunk.f(false);
                    }
                    ++dZ;
                }
                ++dX;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public void sendChunkUpdate(World world, int chunkX, int chunkZ, Collection<? extends Player> players) {
        for (Player player : players) {
            this.sendChunkUpdate(world, chunkX, chunkZ, player);
        }
    }

    @Override
    public void sendChunkUpdate(World world, int chunkX, int chunkZ, Player player) {
        Chunk chunk = ((CraftWorld)world).getHandle().getChunkAt(chunkX, chunkZ);
        EntityPlayer human = ((CraftPlayer)player).getHandle();
        Chunk pChunk = human.world.getChunkAtWorldCoords(human.getChunkCoordinates());
        if (this.distanceTo(pChunk, chunk) < 5) {
            PacketPlayOutMapChunk packet = new PacketPlayOutMapChunk(chunk, 65534);
            human.playerConnection.sendPacket((Packet)packet);
        }
    }

    @Override
    public void sendChunkUpdate(World world, int chunkX, int y, int chunkZ, Collection<? extends Player> players) {
        for (Player player : players) {
            this.sendChunkUpdate(world, chunkX, y, chunkZ, player);
        }
    }

    @Override
    public void sendChunkUpdate(World world, int chunkX, int y, int chunkZ, Player player) {
        Chunk chunk = ((CraftWorld)world).getHandle().getChunkAt(chunkX, chunkZ);
        EntityPlayer human = ((CraftPlayer)player).getHandle();
        Chunk pChunk = human.world.getChunkAtWorldCoords(human.getChunkCoordinates());
        if (this.distanceTo(pChunk, chunk) < 5) {
            PacketPlayOutMapChunk packet = new PacketPlayOutMapChunk(chunk, 256 * y - 1);
            human.playerConnection.sendPacket((Packet)packet);
        }
    }

    private static Field getChunkField(Object chunk) throws NoSuchFieldException, SecurityException {
        if (cachedChunkModified == null) {
            cachedChunkModified = chunk.getClass().getDeclaredField("s");
            cachedChunkModified.setAccessible(true);
        }
        return cachedChunkModified;
    }

    private int distanceTo(Chunk from, Chunk to) {
        if (!from.world.getWorldData().getName().equals(to.world.getWorldData().getName())) {
            return 100;
        }
        double var2 = to.locX - from.locX;
        double var4 = to.locZ - from.locZ;
        return (int)Math.sqrt(var2 * var2 + var4 * var4);
    }
}

