/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi.request;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ru.beykerykt.lightapi.chunks.ChunkCache;
import ru.beykerykt.lightapi.chunks.ChunkInfo;
import ru.beykerykt.lightapi.request.DataRequest;
import ru.beykerykt.lightapi.server.ServerModManager;

public class RequestSteamMachine
implements Runnable {
    private boolean isStarted;
    private boolean needRequestUpdate;
    private boolean needChunkUpdate;
    protected CopyOnWriteArrayList<DataRequest> REQUEST_QUEUE = new CopyOnWriteArrayList();
    protected int maxIterationsPerTick;
    protected int iteratorCount;
    private ScheduledFuture<?> sch;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public void start(int ticks, int maxIterationsPerTick) {
        if (!this.isStarted) {
            this.isStarted = true;
            this.needRequestUpdate = false;
            this.needChunkUpdate = false;
            this.maxIterationsPerTick = maxIterationsPerTick;
            this.iteratorCount = 0;
            this.sch = this.executor.scheduleWithFixedDelay(this, 0L, 50 * ticks, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        if (this.isStarted) {
            this.isStarted = false;
            this.needRequestUpdate = false;
            this.needChunkUpdate = false;
            this.REQUEST_QUEUE.clear();
            this.maxIterationsPerTick = 0;
            this.iteratorCount = 0;
            this.sch.cancel(false);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean addToQueue(DataRequest request) {
        if (request == null || this.REQUEST_QUEUE.contains(request)) {
            return false;
        }
        this.REQUEST_QUEUE.add(request);
        if (!this.needRequestUpdate) {
            this.needRequestUpdate = true;
        }
        return true;
    }

    @Override
    public void run() {
        if (!ChunkCache.CHUNK_INFO_QUEUE.isEmpty()) {
            this.needChunkUpdate = true;
        }
        if (this.needRequestUpdate) {
            this.needRequestUpdate = false;
            this.iteratorCount = 0;
            while (!this.REQUEST_QUEUE.isEmpty() && this.iteratorCount < this.maxIterationsPerTick) {
                DataRequest request = this.REQUEST_QUEUE.get(0);
                request.process();
                ++this.iteratorCount;
                this.REQUEST_QUEUE.remove(0);
            }
        }
        if (this.needChunkUpdate) {
            this.needChunkUpdate = false;
            while (!ChunkCache.CHUNK_INFO_QUEUE.isEmpty()) {
                ChunkInfo info = ChunkCache.CHUNK_INFO_QUEUE.get(0);
                ServerModManager.getNMSHandler().sendChunkUpdate(info.getWorld(), info.getChunkX(), info.getChunkYHeight(), info.getChunkZ(), info.getReceivers());
                ChunkCache.CHUNK_INFO_QUEUE.remove(0);
            }
        }
    }
}

