/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import java.util.Random;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;

public class Permutations {
    public static int[] randomPermutation(int size) {
        Random r = new Random();
        int[] result = new int[size];
        int j = 0;
        while (j < size) {
            result[j] = j;
            ++j;
        }
        j = size - 1;
        while (j > 0) {
            int k = r.nextInt(j);
            int temp = result[j];
            result[j] = result[k];
            result[k] = temp;
            --j;
        }
        return result;
    }

    public static int[] randomSubset(int k, int n) {
        assert (k > 0 && k <= n);
        Random r = new Random();
        int t = 0;
        int m = 0;
        int[] result = new int[k];
        while (m < k) {
            double u = r.nextDouble();
            if ((double)(n - t) * u < (double)(k - m)) {
                result[m] = t;
                ++m;
            }
            ++t;
        }
        return result;
    }

    public static DoubleMatrix permutationDoubleMatrixFromPivotIndices(int size, int[] ipiv) {
        int n = ipiv.length;
        int[] indices = new int[size];
        int i = 0;
        while (i < size) {
            indices[i] = i;
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = ipiv[i] - 1;
            int t = indices[i];
            indices[i] = indices[j];
            indices[j] = t;
            ++i;
        }
        DoubleMatrix result = new DoubleMatrix(size, size);
        int i2 = 0;
        while (i2 < size) {
            result.put(indices[i2], i2, 1.0);
            ++i2;
        }
        return result;
    }

    public static FloatMatrix permutationFloatMatrixFromPivotIndices(int size, int[] ipiv) {
        int n = ipiv.length;
        int[] indices = new int[size];
        int i = 0;
        while (i < size) {
            indices[i] = i;
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = ipiv[i] - 1;
            int t = indices[i];
            indices[i] = indices[j];
            indices[j] = t;
            ++i;
        }
        FloatMatrix result = new FloatMatrix(size, size);
        int i2 = 0;
        while (i2 < size) {
            result.put(indices[i2], i2, 1.0f);
            ++i2;
        }
        return result;
    }
}

