/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.benchmark;

import org.jblas.FloatMatrix;
import org.jblas.benchmark.Benchmark;
import org.jblas.benchmark.BenchmarkResult;
import org.jblas.benchmark.Timer;

class JavaFloatMultiplicationBenchmark
implements Benchmark {
    JavaFloatMultiplicationBenchmark() {
    }

    @Override
    public String getName() {
        return "Java matrix multiplication, single precision";
    }

    private void mmuli(int n, float[] A, float[] B, float[] C) {
        int i = 0;
        while (i < n * n) {
            C[i] = 0.0f;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int jn = j * n;
            int k = 0;
            while (k < n) {
                int kn = k * n;
                float bkjn = B[k + jn];
                int i2 = 0;
                while (i2 < n) {
                    int n2 = i2 + jn;
                    C[n2] = C[n2] + A[i2 + kn] * bkjn;
                    ++i2;
                }
                ++k;
            }
            ++j;
        }
    }

    @Override
    public BenchmarkResult run(int size, double seconds) {
        int counter = 0;
        long ops = 0L;
        float[] A = FloatMatrix.randn((int)size, (int)size).data;
        float[] B = FloatMatrix.randn((int)size, (int)size).data;
        float[] C = FloatMatrix.randn((int)size, (int)size).data;
        Timer t = new Timer();
        t.start();
        while (!t.ranFor(seconds)) {
            this.mmuli(size, A, B, C);
            ++counter;
            ops += 2L * (long)size * (long)size * (long)size;
        }
        t.stop();
        return new BenchmarkResult(ops, t.elapsedSeconds(), counter);
    }
}

