/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase.commands;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginLanguage;
import org.generallib.pluginbase.language.DefaultLanguages;

public abstract class SubCommand {
    protected final String name;
    protected final String[] aliases;
    protected final String permission;
    protected PluginLanguage.Language permissionDeniedMessage = DefaultLanguages.General_NotEnoughPermission;
    protected final PluginLanguage.Language description;
    protected final PluginLanguage.Language[] usage;
    protected final PluginBase base;
    protected ChatColor commandColor = ChatColor.GOLD;
    private int arguments = -1;

    public SubCommand(PluginBase base, String permission, PluginLanguage.Language description, PluginLanguage.Language[] usage, int arguments, String name, String ... aliases) {
        this.base = base;
        this.name = name;
        this.aliases = aliases;
        this.permission = permission;
        this.description = description;
        this.usage = usage;
        this.arguments = arguments;
    }

    public PluginLanguage.Language getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public void setPermissionDeniedMessage(PluginLanguage.Language permissionDeniedMessage) {
        this.permissionDeniedMessage = permissionDeniedMessage;
    }

    public ChatColor getCommandColor() {
        return this.commandColor;
    }

    public int getArguments() {
        return this.arguments;
    }

    protected void setArguments(int arguments) {
        this.arguments = arguments;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (this.arguments != -1 && args.length != this.arguments) {
            return false;
        }
        if (sender == null || sender instanceof ConsoleCommandSender) {
            return this.executeConsole(sender, args);
        }
        Player player = (Player)sender;
        if (player.isOp()) {
            return this.executeOp(player, args);
        }
        return this.executeUser(player, args);
    }

    protected boolean executeConsole(CommandSender sender, String[] args) {
        this.base.getLogger().info("Not allowed to execute from Console.");
        return true;
    }

    protected boolean executeOp(Player op, String[] args) {
        op.sendMessage(ChatColor.RED + "Not allowed to execute from OP.");
        return true;
    }

    protected boolean executeUser(Player player, String[] args) {
        player.sendMessage(ChatColor.RED + "Not allowed to execute from User.");
        return true;
    }

    public boolean testPermission(CommandSender sender) {
        if (this.permission == null) {
            return true;
        }
        if (!this.testPermissionSilent(sender)) {
            this.base.sendMessage(sender, this.permissionDeniedMessage);
            return false;
        }
        return true;
    }

    public boolean testPermissionSilent(CommandSender sender) {
        if (this.permission == null) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getPermission() {
        return this.permission;
    }

    public PluginLanguage.Language getDescription() {
        return this.description;
    }

    public PluginLanguage.Language[] getUsage() {
        return this.usage;
    }

    public String toString() {
        return this.name;
    }
}

