/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.util.Set;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.manager.TransferPairProvider;

public abstract class PluginManager<T extends PluginBase>
implements TransferPairProvider {
    public static final int FASTEST_PRIORITY = 0;
    public static final int NORM_PRIORITY = 5;
    public static final int SLOWEST_PRIORITY = 10;
    protected final T base;
    private final int loadPriority;

    public PluginManager(T base, int loadPriority) {
        this.base = base;
        if (loadPriority < 0 || loadPriority > 10) {
            throw new IllegalArgumentException("load priority out of bound.");
        }
        this.loadPriority = loadPriority;
    }

    public int getLoadPriority() {
        return this.loadPriority;
    }

    protected abstract void onEnable() throws Exception;

    protected abstract void onDisable() throws Exception;

    protected abstract void onReload() throws Exception;

    @Override
    public Set<String> getValidDBTypes() {
        return null;
    }

    @Override
    public Set<DatabaseTransferTask.TransferPair> getTransferPair(String dbTypeFrom) {
        return null;
    }
}

