/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginProcedure;
import org.generallib.serializetools.Utf8YamlConfiguration;

public abstract class PluginConfig
implements PluginProcedure {
    protected PluginBase base;
    private FileConfiguration config;
    private File file;
    public int Command_Help_SentencePerPage = 6;
    public int Languages_Double_DecimalPoints = 4;
    public boolean Plugin_Enabled = true;
    public boolean Plugin_Debugging = false;
    public String Plugin_Language_Default = "en";
    public List<String> Plugin_Language_List = new ArrayList<String>(){
        {
            this.add("en");
            this.add("ko");
        }
    };
    public String Plugin_Prefix = "&6[&5?&6]";
    public String Plugin_ServerName = "yourServer";
    public boolean MySql_Enabled = true;
    public String MySql_DBAddress = "localhost:3306";
    public String MySql_DBName = "somedb";
    public String MySql_DBUser = "root";
    public String MySql_DBPassword = "1234";

    @Override
    public void onEnable(PluginBase base) throws Exception {
        this.base = base;
        this.config = new Utf8YamlConfiguration();
        if (!base.getDataFolder().exists()) {
            base.getDataFolder().mkdirs();
        }
        this.file = new File(base.getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.config.load(this.file);
        this.validateAndLoad();
        this.save();
    }

    @Override
    public void onDisable(PluginBase base) throws Exception {
        this.save();
    }

    @Override
    public void onReload(PluginBase base) throws Exception {
        this.reload();
    }

    private static String convertToConfigName(String fieldName) {
        return fieldName.replaceAll("_", ".");
    }

    private static String converToFieldName(String configKey) {
        return configKey.replaceAll("\\.", "_");
    }

    protected void validateAndLoad() {
        this.base.getLogger().info("Validating config...");
        Field[] fields = this.getClass().getFields();
        int addedNew = 0;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String configName = PluginConfig.convertToConfigName(field.getName());
                Object obj = field.get(this);
                if (!this.config.contains(configName)) {
                    this.config.set(configName, obj);
                    ++addedNew;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.base.getLogger().severe(e.getMessage());
            }
            ++n2;
        }
        try {
            this.save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.base.getLogger().info("Added [" + addedNew + "] new configs with default value.");
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] e = fields;
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            Field field = e[n];
            fieldNames.add(field.getName());
            ++n;
        }
        int deletedOld = 0;
        int loaded = 0;
        Configuration root = this.config.getRoot();
        Set keys = root.getKeys(true);
        for (String key : keys) {
            try {
                if (this.config.isConfigurationSection(key) || key.contains("_COMMENT_")) continue;
                String fieldName = PluginConfig.converToFieldName(key);
                if (!fieldNames.contains(fieldName)) {
                    this.config.set(key, null);
                    ++deletedOld;
                    continue;
                }
                Field field = this.getClass().getField(fieldName);
                field.set(this, this.config.get(key));
                ++loaded;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e2) {
                this.base.getLogger().severe(e2.getMessage());
            }
        }
        try {
            this.save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.base.getLogger().info("Deleted [" + deletedOld + "] old configs and loaded [" + loaded + "] configs.");
        this.base.getLogger().info("Validation and Loading complete!");
    }

    public void save() throws IOException {
        String[] split;
        this.base.getLogger().info("Saving to [" + this.file.getName() + "]...");
        FileOutputStream stream = new FileOutputStream(this.file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, Charset.forName("UTF-8"));
        String output = this.config.saveToString();
        String[] stringArray = split = output.split("\n");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.contains("_COMMENT_")) {
                writer.write("#" + s.replaceAll("'", "").substring(s.indexOf(58) + 1) + "\n");
            } else {
                writer.write(String.valueOf(s) + "\n");
            }
            ++n2;
        }
        writer.close();
        stream.close();
        this.base.getLogger().info("Complete!");
    }

    public void reload() throws IOException, InvalidConfigurationException {
        this.base.getLogger().info("Loading [" + this.file.getName() + "]...");
        this.config.load(this.file);
        this.base.getLogger().info("Complete!");
        this.validateAndLoad();
    }
}

