/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.generallib.main.FakePlugin;
import org.generallib.pluginbase.PluginAPISupport;
import org.generallib.pluginbase.PluginCommandExecutor;
import org.generallib.pluginbase.PluginConfig;
import org.generallib.pluginbase.PluginLanguage;
import org.generallib.pluginbase.PluginManager;
import org.generallib.pluginbase.language.DefaultLanguages;

public abstract class PluginBase
extends JavaPlugin {
    private static final ExecutorService pool = Executors.newScheduledThreadPool(4, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setPriority(1);
            return thread;
        }
    });
    private final Queue<Runnable> queuedTasks = new LinkedList<Runnable>();
    final Map<Class<? extends PluginManager>, PluginManager> pluginManagers = new HashMap<Class<? extends PluginManager>, PluginManager>();
    private PluginConfig config;
    public PluginLanguage lang;
    public PluginCommandExecutor executor;
    public PluginAPISupport APISupport;

    public static void runAsynchronously(Runnable run) {
        pool.execute(run);
    }

    public boolean runPerTick(Runnable run) {
        if (this.queuedTasks.size() > 1000000) {
            return false;
        }
        this.queuedTasks.add(run);
        return true;
    }

    public PluginBase(PluginConfig config, String mainCommand, String adminPermission) {
        this.config = config;
        try {
            config.onEnable(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While loading config:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
            this.setEnabled(false);
        }
        String def = config.Plugin_Language_Default;
        HashSet<String> list = new HashSet<String>(config){
            {
                this.addAll(pluginConfig.Plugin_Language_List);
            }
        };
        this.lang = new PluginLanguage((Set<String>)list, def);
        this.executor = new PluginCommandExecutor(mainCommand, adminPermission);
        this.APISupport = new PluginAPISupport();
    }

    private void initiatePluginProcedures() {
        try {
            if (this.isEnabled()) {
                this.lang.onEnable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While loading lang:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
            this.setEnabled(false);
        }
        try {
            if (this.isEnabled()) {
                this.executor.onEnable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While loading command executor:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
            this.setEnabled(false);
        }
        try {
            if (this.isEnabled()) {
                this.APISupport.onEnable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While loading APISupport:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
            this.setEnabled(false);
        }
        TreeMap<Integer, Set<PluginManager>> map = new TreeMap<Integer, Set<PluginManager>>(){
            {
                int i = 0;
                while (i <= 10) {
                    this.put(i, new HashSet());
                    ++i;
                }
            }
        };
        for (Map.Entry<Class<? extends PluginManager>, PluginManager> entry : this.pluginManagers.entrySet()) {
            Set set = (Set)map.get(entry.getValue().getLoadPriority());
            set.add(entry.getValue());
        }
        for (Map.Entry<Class<PluginManager<Object>>, PluginManager<Object>> entry : map.entrySet()) {
            Set managers = (Set)((Object)entry.getValue());
            for (PluginManager manager : managers) {
                try {
                    if (this.isEnabled()) {
                        manager.onEnable();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getLogger().severe("While Enabling [" + manager.getClass().getSimpleName() + "]:");
                    this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
                    this.setEnabled(false);
                    this.getLogger().info(this.lang.parseFirstString(DefaultLanguages.Plugin_WillBeDisabled));
                    return;
                }
                if (!(manager instanceof Listener) || !this.isEnabled()) continue;
                this.getServer().getPluginManager().registerEvents((Listener)manager, (Plugin)this);
            }
        }
    }

    private void finalizeDisableProcedures() {
        try {
            if (this.config != null) {
                this.config.onDisable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While disabling config:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            if (this.lang != null) {
                this.lang.onDisable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While disabling lang:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            if (this.executor != null) {
                this.executor.onDisable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While disabling command executor:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            if (this.APISupport != null) {
                this.APISupport.onDisable(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While disabling APISupport:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        TreeMap<Integer, Set<PluginManager>> map = new TreeMap<Integer, Set<PluginManager>>(){
            {
                int i = 0;
                while (i <= 10) {
                    this.put(i, new HashSet());
                    ++i;
                }
            }
        };
        for (Map.Entry<Class<? extends PluginManager>, PluginManager> entry : this.pluginManagers.entrySet()) {
            Set set = (Set)map.get(entry.getValue().getLoadPriority());
            set.add(entry.getValue());
        }
        for (Map.Entry<Class<PluginManager<Object>>, PluginManager<Object>> entry : map.entrySet()) {
            Set managers = (Set)((Object)entry.getValue());
            for (PluginManager manager : managers) {
                try {
                    manager.onDisable();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getLogger().severe("While Enabling [" + manager.getClass().getSimpleName() + "]:");
                    this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
                    this.setEnabled(false);
                    this.getLogger().info(this.lang.parseFirstString(DefaultLanguages.Plugin_WillBeDisabled));
                    return;
                }
                if (!(manager instanceof Listener) || !this.isEnabled()) continue;
                this.getServer().getPluginManager().registerEvents((Listener)manager, (Plugin)this);
            }
        }
    }

    public void reloadPluginProcedures() {
        try {
            this.config.onReload(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While reloading config:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            this.lang.onReload(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While reloading lang:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            this.executor.onReload(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While reloading command executor:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        try {
            this.APISupport.onReload(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("While reloading APISupport:");
            this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
        }
        TreeMap<Integer, Set<PluginManager>> map = new TreeMap<Integer, Set<PluginManager>>(){
            {
                int i = 0;
                while (i <= 10) {
                    this.put(i, new HashSet());
                    ++i;
                }
            }
        };
        for (Map.Entry<Class<? extends PluginManager>, PluginManager> entry : this.pluginManagers.entrySet()) {
            Set set = (Set)map.get(entry.getValue().getLoadPriority());
            set.add(entry.getValue());
        }
        for (Map.Entry<Class<PluginManager<Object>>, PluginManager<Object>> entry : map.entrySet()) {
            Set managers = (Set)((Object)entry.getValue());
            for (PluginManager manager : managers) {
                try {
                    if (!this.isEnabled()) continue;
                    manager.onReload();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getLogger().severe("While Enabling [" + manager.getClass().getSimpleName() + "]:");
                    this.getLogger().severe(String.valueOf(e.getClass().getSimpleName()) + "@" + e.getMessage());
                    this.setEnabled(false);
                    this.getLogger().info(this.lang.parseFirstString(DefaultLanguages.Plugin_WillBeDisabled));
                    return;
                }
            }
        }
    }

    public void onEnable() {
        this.initiatePluginProcedures();
        if (this.isEnabled()) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    HashSet<Runnable> send = new HashSet<Runnable>();
                    int i = 0;
                    while (i < 1000 && !PluginBase.this.queuedTasks.isEmpty()) {
                        Runnable run = (Runnable)PluginBase.this.queuedTasks.poll();
                        if (run != null) {
                            send.add(run);
                        }
                        ++i;
                    }
                    for (Runnable run : send) {
                        run.run();
                    }
                }
            }, 10L, 1L);
        }
    }

    public void onDisable() {
        this.finalizeDisableProcedures();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.executor.onCommand(sender, command, label, args);
    }

    public void sendMessage(CommandSender sender, PluginLanguage.Language language) {
        if (sender instanceof Player) {
            this.sendMessage((Player)sender, language);
        } else {
            sender.sendMessage(this.lang.parseStrings(language));
        }
    }

    public void sendMessage(Player player, PluginLanguage.Language language) {
        String localeSimplified = FakePlugin.nmsEntityManager.getLocale(player);
        String[] stringArray = this.lang.parseStrings((CommandSender)player, language, localeSimplified);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            player.sendMessage(String.valueOf(this.lang.colorize(((PluginConfig)this.getPluginConfig()).Plugin_Prefix)) + " " + msg);
            ++n2;
        }
    }

    public <T extends PluginConfig> T getPluginConfig() {
        return (T)this.config;
    }

    public Map<Class<? extends PluginManager>, PluginManager> getPluginManagers() {
        return this.pluginManagers;
    }

    public void registerManager(PluginManager manager) {
        this.pluginManagers.put(manager.getClass(), manager);
    }

    public <T extends PluginManager> T getManager(Class<? extends PluginManager> clazz) {
        return (T)this.pluginManagers.get(clazz);
    }
}

