/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.math.expression;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;

public class ParsableCalculator {
    public static final Map<Character, Operation> operations = new HashMap<Character, Operation>(){
        {
            this.put(Character.valueOf('+'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return num1 + num2;
                }
            });
            this.put(Character.valueOf('-'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return num1 - num2;
                }
            });
            this.put(Character.valueOf('*'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return num1 * num2;
                }
            });
            this.put(Character.valueOf('/'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return num1 / num2;
                }
            });
            this.put(Character.valueOf('^'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return Math.pow(num1, num2);
                }
            });
            this.put(Character.valueOf('%'), new Operation(){

                @Override
                public double calc(double num1, double num2) {
                    return num1 % num2;
                }
            });
        }
    };
    private static final Map<Character, Integer> precedence = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('+'), 2);
            this.put(Character.valueOf('-'), 2);
            this.put(Character.valueOf('*'), 3);
            this.put(Character.valueOf('/'), 3);
            this.put(Character.valueOf('^'), 4);
            this.put(Character.valueOf('%'), 3);
        }
    };
    private final Map<String, DecimalReplacer> replaces = new HashMap<String, DecimalReplacer>();
    private static Stack<String> stack = new Stack();
    private char[] text;
    private int index;
    private Stack<Character> op = new Stack();
    private Queue<String> output = new LinkedList<String>();

    public static void main(String[] ar) {
        ParsableCalculator calc = new ParsableCalculator();
        Scanner sc = new Scanner(System.in);
        while (true) {
            try {
                while (true) {
                    System.out.print("Calc? >> ");
                    String input = sc.nextLine();
                    System.out.println("Result: " + calc.parse(input));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void registerPlaceHolder(String name, DecimalReplacer rep) {
        this.replaces.put(name, rep);
    }

    public double parse(String input) {
        stack.clear();
        Queue<String> output = this.eval(input);
        while (!output.isEmpty()) {
            String out = output.poll();
            if (out.length() == 1 && operations.containsKey(Character.valueOf(out.charAt(0)))) {
                char op = out.charAt(0);
                double num2 = Double.parseDouble(stack.pop());
                double num1 = Double.parseDouble(stack.pop());
                stack.push(String.valueOf(operations.get(Character.valueOf(op)).calc(num1, num2)));
                continue;
            }
            stack.push(out);
        }
        return Double.parseDouble(stack.pop());
    }

    private Queue<String> eval(String input) {
        this.op.clear();
        this.output.clear();
        this.text = input.toCharArray();
        this.index = 0;
        input = input.toLowerCase().replaceAll("[ \\t]", "");
        for (Map.Entry<String, DecimalReplacer> entry : this.replaces.entrySet()) {
            input = entry.getValue().replace() >= 0.0 ? input.replaceAll(entry.getKey(), String.valueOf(entry.getValue().replace())) : input.replaceAll(entry.getKey(), "(0" + String.valueOf(String.valueOf(entry.getValue().replace()) + ")"));
        }
        char[] chars = input.toCharArray();
        String numStr = "";
        int index = 0;
        while (index < chars.length) {
            char c = chars[index];
            if (Character.isDigit(c) || c == '.') {
                numStr = String.valueOf(numStr) + c;
            } else {
                if (!numStr.equals("")) {
                    this.output.add(numStr);
                    numStr = "";
                }
                if (c == '(') {
                    this.op.push(Character.valueOf(c));
                } else if (c == ')') {
                    char operator;
                    while ((operator = this.op.pop().charValue()) != '(') {
                        this.output.add(String.valueOf(operator));
                    }
                } else if (operations.containsKey(Character.valueOf(c))) {
                    if (this.output.isEmpty()) {
                        throw new PatternSyntaxException("Cannot use sign infront of number. Use parenthesis ex) (0 - 5)", input, index);
                    }
                    if (this.op.isEmpty()) {
                        this.op.push(Character.valueOf(c));
                    } else if (this.op.peek().charValue() == '(') {
                        this.op.push(Character.valueOf(c));
                    } else if (this.op.peek().charValue() == '^') {
                        this.op.push(Character.valueOf(c));
                    } else {
                        int precBefore = precedence.get(this.op.peek());
                        int precAfter = precedence.get(Character.valueOf(c));
                        if (precAfter <= precBefore) {
                            this.output.add(String.valueOf(this.op.pop()));
                        }
                        this.op.push(Character.valueOf(c));
                    }
                } else {
                    throw new PatternSyntaxException("Unrecognized character", input, index);
                }
            }
            ++index;
        }
        if (!numStr.equals("")) {
            this.output.add(numStr);
            numStr = "";
        }
        while (!this.op.isEmpty()) {
            this.output.add(String.valueOf(this.op.pop()));
        }
        return this.output;
    }

    private void ignoreWhiteSpaces() {
        while (this.text[this.index] != ' ' && this.text[this.index] != '\t') {
            ++this.index;
        }
    }

    private double readNumber() {
        StringBuilder builder = new StringBuilder();
        while (Character.isDigit(this.text[this.index])) {
            builder.append(this.text[this.index++]);
        }
        if (this.text[this.index++] == '.') {
            builder.append(".");
        }
        while (Character.isDigit(this.text[this.index])) {
            builder.append(this.text[this.index++]);
        }
        return Double.parseDouble(builder.toString());
    }

    public static interface DecimalReplacer {
        public double replace();
    }

    public static interface Operation {
        public double calc(double var1, double var3);
    }

    public static enum Operators {
        PLUS('+'),
        MINUS('-'),
        MULTIPLY('*'),
        DIVIDE('/'),
        POWER('^'),
        REMAINDER('%'),
        UNARYMINUS('-');

        private char c;

        private Operators(char c) {
            this.c = c;
        }

        public String toString() {
            return String.valueOf(this.c);
        }

        public static Operators getOperator(char c) {
            switch (c) {
                case '+': {
                    return PLUS;
                }
                case '-': {
                    return MINUS;
                }
                case '*': {
                    return MULTIPLY;
                }
                case '/': {
                    return DIVIDE;
                }
                case '^': {
                    return POWER;
                }
                case '%': {
                    return REMAINDER;
                }
            }
            return null;
        }
    }
}

