/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.hash.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashGeneratorUtils {
    private HashGeneratorUtils() {
    }

    public static String generateMD5(String message) throws Exception {
        return HashGeneratorUtils.hashString(message, "MD5");
    }

    public static String generateSHA1(String message) throws Exception {
        return HashGeneratorUtils.hashString(message, "SHA-1");
    }

    public static String generateSHA256(String message) throws Exception {
        return HashGeneratorUtils.hashString(message, "SHA-256");
    }

    private static String hashString(String message, String algorithm) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(message.getBytes("UTF-8"));
            return HashGeneratorUtils.convertByteArrayToHexString(hashedBytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new Exception("Could not generate hash from String", ex);
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < arrayBytes.length) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return stringBuffer.toString();
    }
}

