/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.database.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import org.generallib.database.Database;

public class DatabaseFile<T>
extends Database<T> {
    private final Type type;
    private File folder;

    public DatabaseFile(File folder, Type type) {
        this.folder = folder;
        this.type = type;
        folder.mkdirs();
    }

    @Override
    public T load(String key, T def) {
        Object result;
        block34: {
            File file = new File(this.folder, key);
            if (!file.exists()) {
                return def;
            }
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            result = def;
            String ser = "";
            try {
                try {
                    String buff;
                    fis = new FileInputStream(file);
                    isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8").newDecoder());
                    br = new BufferedReader(isr);
                    while ((buff = br.readLine()) != null) {
                        ser = String.valueOf(ser) + buff;
                    }
                    result = this.deserialize(ser, this.type);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block34;
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public synchronized void save(String key, T value) {
        block51: {
            File dest = new File(this.folder, key);
            if (value == null) {
                dest.delete();
                return;
            }
            File file = new File(this.folder, String.valueOf(key) + "_tmp");
            file.getParentFile().mkdirs();
            FileChannel fc = null;
            FileOutputStream fos = null;
            BufferedWriter bw = null;
            FileLock lock = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    fc = fos.getChannel();
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8").newEncoder()));
                    String ser = this.serialize(value, this.type);
                    lock = fc.lock();
                    bw.write(ser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    try {
                        if (fc != null) {
                            fc.close();
                        }
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                    try {
                        if (file != null && dest != null) {
                            Files.move(file.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e6) {
                        e6.printStackTrace();
                    }
                    file.delete();
                    break block51;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (file != null && dest != null) {
                        Files.move(file.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                file.delete();
                throw throwable;
            }
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (file != null && dest != null) {
                    Files.move(file.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            file.delete();
        }
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        File[] fileArray = this.folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            keys.add(file.getName());
            ++n2;
        }
        return keys;
    }

    @Override
    public boolean has(String key) {
        String[] stringArray = this.folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.equalsIgnoreCase(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

