/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.database;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.generallib.database.serialize.ItemStackSerializer;
import org.generallib.database.serialize.LocationSerializer;
import org.generallib.database.serialize.UUIDSerializer;

public abstract class Database<T> {
    private static GsonBuilder builder = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128, 8}).enableComplexMapKeySerialization().registerTypeAdapter(Location.class, (Object)new LocationSerializer()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).registerTypeAdapter(UUID.class, (Object)new UUIDSerializer());
    private Gson gson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTypeAdapter(Class<?> clazz, Object obj) {
        GsonBuilder gsonBuilder = builder;
        synchronized (gsonBuilder) {
            builder.registerTypeAdapter(clazz, obj);
        }
    }

    public abstract T load(String var1, T var2);

    public abstract void save(String var1, T var2);

    public abstract boolean has(String var1);

    public abstract Set<String> getKeys();

    public String serialize(Object obj) {
        if (this.gson == null) {
            this.gson = builder.create();
        }
        return this.gson.toJson(obj);
    }

    public String serialize(Object obj, Type clazz) {
        if (this.gson == null) {
            this.gson = builder.create();
        }
        return this.gson.toJson(obj, clazz);
    }

    public Object deserialize(String ser, Type clazz) {
        if (this.gson == null) {
            this.gson = builder.create();
        }
        return this.gson.fromJson(ser, clazz);
    }
}

