/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.binary.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LittleEndianReader {
    private ByteBuffer bytebuffer;

    public LittleEndianReader(byte[] data) {
        this.bytebuffer = ByteBuffer.wrap(data);
        this.bytebuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte readByte() {
        return this.bytebuffer.get();
    }

    public short readShort() {
        return this.bytebuffer.getShort();
    }

    public void putByte(byte b) {
        this.bytebuffer.position(this.bytebuffer.position() - 1);
        this.bytebuffer.put(b);
    }

    public void putShort(short s) {
        this.bytebuffer.position(this.bytebuffer.position() - 2);
        this.bytebuffer.putShort(s);
    }

    public void reset() {
        this.bytebuffer.rewind();
    }

    public int getRemaining() {
        return this.bytebuffer.remaining();
    }

    public byte[] toByteArray() {
        return this.bytebuffer.array();
    }
}

