/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootMechanic;

public class VolleyMechanic
extends ShootMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected VolleyType type;
    protected int amount;
    protected double radius;
    protected double yOffset;

    public VolleyMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String strType = mlc.getString(new String[]{"source", "s"}, "REGULAR", new String[0]).toUpperCase();
        this.type = strType.equals("RAIN") ? VolleyType.RAIN : VolleyType.REGULAR;
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 10);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 0.0);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    @Override
    public boolean shoot(SkillMetadata data, AbstractLocation target) {
        SkillCaster caster = data.getCaster();
        ShootMechanic.ProjectileData pd = new ShootMechanic.ProjectileData(caster, this.damage, this.onHitSkill, this.onEndSkill, data.getPower());
        AbstractLocation primeSource = null;
        if (this.type.equals((Object)VolleyType.RAIN)) {
            primeSource = target.clone().add(0.0, this.yOffset, 0.0);
        }
        float velocity = this.velocity;
        if (this.powerAffectsVelocity) {
            velocity *= this.power;
        }
        for (int i = 0; i < this.amount; ++i) {
            AbstractEntity projectile;
            if (this.type.equals((Object)VolleyType.RAIN)) {
                AbstractLocation source = primeSource.clone();
                source.setX(source.getX() - this.radius + MythicMobs.r.nextDouble() * (this.radius * 2.0));
                source.setZ(source.getZ() - this.radius + MythicMobs.r.nextDouble() * (this.radius * 2.0));
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity, pd) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity, pd) : SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity, pd));
            } else {
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, velocity, pd, this.fromOrigin) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, velocity, pd, this.fromOrigin) : SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, velocity, pd, this.fromOrigin));
            }
            new ShootMechanic.ProjectileTracker(this, data, projectile, this.power);
        }
        return true;
    }

    protected static enum VolleyType {
        REGULAR,
        RAIN;

    }
}

