/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.PotionSkill;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;

public class ShootPotionSkill
extends PotionSkill
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float velocity;

    public ShootPotionSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.velocity = mlc.getFloat("velocity", 1.0f);
        this.velocity = mlc.getFloat("v", this.velocity);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        ItemStack potion = new ItemStack(Material.SPLASH_POTION);
        PotionMeta pm = (PotionMeta)potion.getItemMeta();
        pm.addCustomEffect(this.effect, true);
        potion.setItemMeta((ItemMeta)pm);
        Projectile projectile = ((LivingEntity)data.getCaster().getEntity()).launchProjectile(ThrownPotion.class);
        ((ThrownPotion)projectile).setItem(potion);
        projectile.setVelocity(BukkitAdapter.adapt(data.getCaster().getEntity()).getLocation().getDirection().multiply(this.velocity));
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)((LivingEntity)data.getCaster().getEntity()));
        return true;
    }
}

