/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class ShootFireballSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float yield;
    protected float velocity;
    protected int fireticks;
    protected boolean incendiary;
    protected boolean smallfireball;
    protected boolean playsound;

    public ShootFireballSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.yield = mlc.getFloat("yield", 1.0f);
        this.yield = mlc.getFloat("strength", this.yield);
        this.yield = mlc.getFloat("y", this.yield);
        this.yield = mlc.getFloat("s", this.yield);
        this.velocity = mlc.getFloat("velocity", 1.0f);
        this.velocity = mlc.getFloat("v", this.velocity);
        this.fireticks = mlc.getInteger("fireticks", 0);
        this.fireticks = mlc.getInteger("ft", this.fireticks);
        this.incendiary = mlc.getBoolean("incendiary", false);
        this.incendiary = mlc.getBoolean("i", this.incendiary);
        this.smallfireball = mlc.getBoolean(new String[]{"smallfireball", "small", "sml"}, false);
        this.playsound = mlc.getBoolean("playsound", false);
        this.playsound = mlc.getBoolean("ps", this.playsound);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().shootFireball(data.getCaster(), target, this.velocity, this.yield, this.incendiary, this.fireticks, this.smallfireball, this.playsound);
        return true;
    }
}

