/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.Material;

public class SetBlockTypeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private Material mat;
    private byte data;

    public SetBlockTypeMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "DIRT", new String[0]).toUpperCase();
        try {
            this.mat = Material.valueOf((String)strMaterial);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("SETBLOCKTYPE", this.line, "'Material' must be a valid Material type.");
            this.mat = Material.GRAVEL;
            MythicMobs.inst().handleException(ex);
        }
        this.data = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        l.getBlock().setType(this.mat);
        l.getBlock().setData(this.data);
    }
}

