/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PotionEffect effect;
    protected int duration;
    protected int lvl;
    protected boolean overwrite;

    public PotionSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        String potion = mlc.getString("type");
        potion = mlc.getString("effect", potion);
        potion = mlc.getString("t", potion);
        this.duration = mlc.getInteger("duration", 100);
        this.duration = mlc.getInteger("d", this.duration);
        this.lvl = mlc.getInteger("level", 1);
        this.lvl = mlc.getInteger("lvl", this.lvl);
        this.lvl = mlc.getInteger("l", this.lvl);
        this.effect = new PotionEffect(PotionEffectType.getByName((String)potion), this.duration, this.lvl);
        this.overwrite = mlc.getBoolean(new String[]{"overwrite", "ow", "override", "or", "force"}, false);
        if (this.effect == null) {
            MythicMobs.skillConfigError("POTION", line, "The 'type' attribute must be a valid potion type.");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.effect == null) {
            return false;
        }
        if (this.overwrite) {
            LivingEntity l = (LivingEntity)target.getBukkitEntity();
            l.addPotionEffect(this.effect, true);
        } else {
            target.addPotionEffect(this.effect);
        }
        return true;
    }
}

