/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.util.RandomUtil;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleSphereEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    int points;
    float radius;

    public ParticleSphereEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.points = this.amount;
        this.amount = 1;
        this.radius = mlc.getFloat("radius", 0.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleSphereEffect(data, target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleSphereEffect(data, target.getLocation());
        return true;
    }

    protected void playParticleSphereEffect(SkillMetadata data, AbstractLocation t) {
        Location target = BukkitAdapter.adapt(t);
        Location location = target.clone();
        location.add(0.0, (double)this.yOffset, 0.0);
        for (int i = 0; i < this.points; ++i) {
            Vector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            if (this.directional) {
                this.playDirectionalParticleEffect(target, target, location);
            } else {
                this.playParticleEffect(BukkitAdapter.adapt(t), location);
            }
            location.subtract(vector);
        }
    }

    protected void playDirectionalParticleEffect(Location origin, Location target, Location spawn) {
        Vector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        for (int i = 0; i < this.amount; ++i) {
            Location ln = spawn.clone().add((double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0, (double)this.vSpread + MythicMobs.r.nextDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
        }
    }
}

