/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class ParticleRingEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;
    int points;
    int inc;

    public ParticleRingEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.points = mlc.getInteger("points", 10);
        this.points = mlc.getInteger("pts", this.points);
        this.radius = mlc.getFloat("radius", 10.0f);
        this.radius = mlc.getFloat("r", this.radius);
        if (this.points <= 0) {
            this.points = 1;
        }
        this.amount /= this.points;
        this.inc = 360 / this.points;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.fromOrigin) {
            this.playParticleRingEffect(data, data.getOrigin());
        } else {
            this.playParticleRingEffect(data, target);
        }
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleRingEffect(data, target.getLocation());
        return false;
    }

    protected void playParticleRingEffect(SkillMetadata data, AbstractLocation t) {
        Location target = BukkitAdapter.adapt(t);
        if (target == null) {
            return;
        }
        double bx = target.getX();
        double y = target.getY() + (double)this.yOffset;
        double bz = target.getZ();
        World w = target.getWorld();
        for (double i = 0.0; i < 360.0; i += (double)this.inc) {
            double angle = i * Math.PI / 180.0;
            double x = (int)(bx + (double)this.radius * Math.cos(angle));
            double z = (int)(bz + (double)this.radius * Math.sin(angle));
            Location l = new Location(w, x, y, z);
            if (this.directional) {
                this.playDirectionalParticleEffect(l, target, l);
                continue;
            }
            this.playParticleEffect(l, l);
        }
    }

    protected void playDirectionalParticleEffect(Location origin, Location target, Location spawn) {
        Vector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        for (int i = 0; i < this.amount; ++i) {
            Location ln = spawn.clone().add((double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0, (double)this.vSpread + MythicMobs.r.nextDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
        }
    }
}

