/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleLineEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float distanceBetween;
    float yStartOffset;
    boolean fromOrigin;

    public ParticleLineEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.yStartOffset = mlc.getFloat("ystartoffset", 0.0f);
        this.yStartOffset = mlc.getFloat("ys", this.yStartOffset);
        this.distanceBetween = mlc.getFloat("distancebetween", 0.25f);
        this.distanceBetween = mlc.getFloat("db", this.distanceBetween);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleLineEffect(data.getCaster(), data.getOrigin(), target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleLineEffect(data.getCaster(), data.getOrigin(), target.getLocation());
        return false;
    }

    protected void playParticleLineEffect(SkillCaster am, AbstractLocation origin, AbstractLocation target) {
        Location l;
        Location sl = this.fromOrigin ? BukkitAdapter.adapt(origin).add(0.0, (double)this.yStartOffset, 0.0) : BukkitAdapter.adapt(am.getEntity()).getLocation().add(0.0, (double)this.yStartOffset, 0.0);
        int c = (int)Math.ceil(sl.distance(l = BukkitAdapter.adapt(target)) / (double)this.distanceBetween) - 1;
        if (c <= 0) {
            return;
        }
        Vector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.distanceBetween);
        Location l2 = sl.clone().add(0.0, (double)this.yOffset, 0.0);
        for (int i = 0; i < c; ++i) {
            l2.add(v);
            if (this.directional) {
                this.playDirectionalParticleEffect(sl, l, l2);
                continue;
            }
            this.playParticleEffect(sl, l2);
        }
    }

    protected void playDirectionalParticleEffect(Location origin, Location target, Location spawn) {
        Vector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        for (int i = 0; i < this.amount; ++i) {
            Location ln = spawn.clone().add((double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0, (double)this.vSpread + MythicMobs.r.nextDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
        }
    }
}

