/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.util.RandomUtil;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParticleBoxEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;

    public ParticleBoxEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.radius = mlc.getFloat("radius", 5.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleSphereEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleSphereEffect(target.getLocation());
        return false;
    }

    protected void playParticleSphereEffect(final AbstractLocation t) {
        new BukkitRunnable(){

            public void run() {
                Location target = BukkitAdapter.adapt(t);
                Location location = target.clone();
                location.add(0.0, (double)ParticleBoxEffect.this.yOffset, 0.0);
                for (int i = 0; i < ParticleBoxEffect.this.amount; ++i) {
                    Vector vector = RandomUtil.getRandomVector().multiply(ParticleBoxEffect.this.radius);
                    location.add(vector);
                    new ParticleMaker.ParticlePacket(ParticleBoxEffect.this.strParticle, ParticleBoxEffect.this.hSpread, ParticleBoxEffect.this.vSpread, ParticleBoxEffect.this.hSpread, ParticleBoxEffect.this.pSpeed, 1, true).send(location, ParticleBoxEffect.this.viewDistance);
                    location.subtract(vector);
                }
            }
        }.runTaskAsynchronously((Plugin)MythicMobs.inst());
    }
}

