/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.MissileSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ProjectileMechanic;

public class ModifyProjectileMechanic
extends SkillMechanic
implements INoTargetSkill {
    private ProjectileTrait trait;
    private double value;

    public ModifyProjectileMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String t = mlc.getString(new String[]{"trait", "t"}, "VELOCITY", new String[0]);
        try {
            this.trait = ProjectileTrait.valueOf(t.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.value = mlc.getDouble(new String[]{"value", "v"}, 0.0);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (data.getCallingEvent() instanceof ProjectileMechanic.ProjectileTracker) {
            ProjectileMechanic.ProjectileTracker projectile = (ProjectileMechanic.ProjectileTracker)data.getCallingEvent();
            switch (this.trait) {
                case VELOCITY: {
                    projectile.modifyVelocity(this.value);
                    break;
                }
                case POWER: {
                    projectile.modifyPower((float)this.value);
                    break;
                }
                case GRAVITY: {
                    projectile.modifyGravity((float)this.value);
                    break;
                }
            }
        } else if (data.getCallingEvent() instanceof MissileSkill.MissileTracker) {
            MissileSkill.MissileTracker projectile = (MissileSkill.MissileTracker)data.getCallingEvent();
            switch (this.trait) {
                case VELOCITY: {
                    projectile.modifyVelocity(this.value);
                    break;
                }
                case POWER: {
                    projectile.modifyPower((float)this.value);
                    break;
                }
                case INERTIA: {
                    projectile.modifyInertia((float)this.value);
                    break;
                }
            }
        }
        return true;
    }

    private static enum ProjectileTrait {
        INERTIA,
        GRAVITY,
        POWER,
        VELOCITY;

    }
}

