/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;

public class MessageSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected String message;

    public MessageSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        this.message = mlc.getString("message");
        this.message = mlc.getString("msg", this.message);
        this.message = mlc.getString("m", this.message);
        try {
            this.message = this.message.substring(1, this.message.length() - 1);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("MESSAGE", line, "The 'message' attribute is required.");
            this.message = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
            MythicMobs.inst().handleException(ex);
        }
        MythicMobs.debug(2, "Loaded message skill with message " + this.message);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        MythicMobs.debug(2, "Executing message skill with message: " + this.message);
        String m = SkillString.parseMobVariables(this.message, data.getCaster(), target, data.getTrigger());
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(m);
            return true;
        }
        return false;
    }
}

