/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.DamageSkill;

public class DamagePercentMechanic
extends DamageSkill
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected double percent = 0.1;
    protected boolean currentHealth = false;
    protected boolean ignore_armor = false;

    public DamagePercentMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.percent = mlc.getDouble(new String[]{"percent", "p"}, 0.1);
        this.currentHealth = mlc.getBoolean(new String[]{"current", "ch", "c"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        double damage = this.currentHealth ? target.getHealth() * this.percent * (double)this.power : target.getMaxHealth() * this.percent * (double)this.power;
        MythicMobs.debug(3, "DamagePercent Mechanic Fired for " + damage + " with " + this.power + " power");
        SkillAdapter.get().doDamage(data.getCaster(), target, damage, this.ignore_armor, this.preventKnockback, this.preventImmunity);
        return true;
    }
}

