/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class BlockMaskEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private Material mat;
    private byte data;
    private int radius;
    private int duration;
    private double randomness;
    private boolean sphere;
    private boolean noAir;
    private int radiusSq;

    public BlockMaskEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "GRAVEL", new String[0]).toUpperCase();
        try {
            this.mat = Material.valueOf((String)strMaterial);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("BLOCKMASK", this.line, "'Material' must be a valid Material type.");
            this.mat = Material.GRAVEL;
            MythicMobs.inst().handleException(ex);
        }
        this.data = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 0);
        this.noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        this.randomness = mlc.getDouble(new String[]{"noise", "n"}, 0.0);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        if (this.radius < 0) {
            this.radius = 0;
        }
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(final AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        if (this.radius == 0) {
            for (Player p : l.getWorld().getPlayers()) {
                if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                p.sendBlockChange(l, this.mat, this.data);
            }
        } else {
            for (Location ll : this.getBlocksInRadius(l, true)) {
                for (Player p : l.getWorld().getPlayers()) {
                    if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                    p.sendBlockChange(ll, this.mat, this.data);
                }
            }
        }
        if (this.duration > 0) {
            TaskManager.get().runLater(new Runnable(){

                @Override
                public void run() {
                    Location l = BukkitAdapter.adapt(location);
                    if (BlockMaskEffect.this.radius == 0) {
                        for (Player p : l.getWorld().getPlayers()) {
                            if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                            p.sendBlockChange(l, l.getBlock().getType(), l.getBlock().getData());
                        }
                    } else {
                        for (Location ll : BlockMaskEffect.this.getBlocksInRadius(l, false)) {
                            for (Player p : l.getWorld().getPlayers()) {
                                if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                                p.sendBlockChange(ll, ll.getBlock().getType(), ll.getBlock().getData());
                            }
                        }
                    }
                }
            }, this.duration);
        }
    }

    private List<Location> getBlocksInRadius(Location l, boolean randomize) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > (double)this.radiusSq || randomize && this.randomness > 0.0 && this.randomness < MythicMobs.r.nextDouble()) continue;
                    if (this.noAir && newloc.getBlock().getType().isOccluding()) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.noAir) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }
}

