/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class ArrowVolleySkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int amount;
    protected int spread;
    protected int fireTicks;
    protected int removeDelay;
    protected float velocity;

    public ArrowVolleySkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.amount = mlc.getInteger("amount", 20);
        this.amount = mlc.getInteger("arrows", this.amount);
        this.amount = mlc.getInteger("a", this.amount);
        this.spread = mlc.getInteger("spread", 45);
        this.spread = mlc.getInteger("s", this.spread);
        this.fireTicks = mlc.getInteger("fireticks", 0);
        this.fireTicks = mlc.getInteger("f", this.fireTicks);
        this.velocity = mlc.getFloat("velocity", 20.0f);
        this.velocity = mlc.getFloat("v", this.velocity);
        this.velocity /= 10.0f;
        this.removeDelay = mlc.getInteger("removedelay", 200);
        this.removeDelay = mlc.getInteger("rd", this.removeDelay);
        this.removeDelay = mlc.getInteger("r", this.removeDelay);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target, this.amount, this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target.getLocation(), this.amount, this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return true;
    }
}

