/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.HashSet;
import java.util.Set;

public class TCBiomeCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition {
    private Set<String> biomes = new HashSet<String>();
    private boolean strict = false;

    public TCBiomeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String b = mlc.getString(new String[]{"biome", "b"}, "PLAINS", this.conditionVar).toUpperCase();
        this.strict = mlc.getBoolean(new String[]{"strict", "s"}, false);
        for (String s : b.split(",")) {
            this.biomes.add(s);
        }
    }

    @Override
    public boolean check(AbstractLocation location) {
        if (!MythicMobs.inst().getCompatibility().getTerrainControl().isPresent()) {
            return false;
        }
        String biome = MythicMobs.inst().getCompatibility().getTerrainControl().get().getBiome(location).toUpperCase();
        if (this.strict) {
            return this.biomes.contains(location.getBiome().toString());
        }
        for (String b : this.biomes) {
            if (!biome.contains(b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean check(AbstractEntity e) {
        return this.check(e.getLocation());
    }
}

