/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.Collection;

public class TriggeredSkill
implements IParentSkill {
    private SkillMetadata data;
    private boolean sync = false;
    private boolean cancel = false;

    public TriggeredSkill(SkillTrigger cause, ActiveMob am, AbstractEntity trigger) {
        this(cause, am, trigger, false);
    }

    public TriggeredSkill(SkillTrigger cause, ActiveMob am, AbstractEntity trigger, boolean sync) {
        this.data = new SkillMetadata(cause, am, trigger);
        this.data.setCallingEvent(this);
        if (sync) {
            this.data.setIsAsync(false);
        } else {
            this.data.setIsAsync(true);
        }
        if (this.data.getTrigger() != null) {
            if (am instanceof ActiveMob) {
                am.setLastAggroCause(this.data.getTrigger());
            }
            this.data.setEntityTarget(trigger);
        }
        this.data.setPower(am.getPower());
        am.getType().executeSkills(this.data.getCause(), this.data);
    }

    public TriggeredSkill(SkillTrigger cause, SkillCaster am, AbstractLocation origin, AbstractEntity trigger, Collection<SkillMechanic> mechanics, boolean sync) {
        this.data = new SkillMetadata(cause, am, trigger);
        this.data.setCallingEvent(this);
        if (sync) {
            this.data.setIsAsync(false);
        } else {
            this.data.setIsAsync(true);
        }
        if (origin != null) {
            this.data.setOrigin(origin);
        }
        if (this.data.getTrigger() != null) {
            this.data.setEntityTarget(trigger);
        }
        this.data.setPower(am.getPower());
        if (this.data.getIsAsync()) {
            for (SkillMechanic ms : mechanics) {
                if (ms.getRunAsync() || !ms.usable(this.data.getCaster(), this.data.getCause())) continue;
                ms.execute(this.data.deepClone().setIsAsync(false));
            }
            TaskManager.get().runAsync(() -> {
                for (SkillMechanic ms : mechanics) {
                    if (!ms.getRunAsync() || !ms.usable(this.data.getCaster(), this.data.getCause())) continue;
                    ms.execute(this.data);
                }
            });
        } else {
            for (SkillMechanic ms : mechanics) {
                if (!ms.usable(this.data.getCaster(), this.data.getCause())) continue;
                ms.execute(this.data);
            }
        }
    }

    @Override
    public void setCancelled() {
        this.cancel = true;
    }

    @Override
    public boolean getCancelled() {
        return this.cancel;
    }
}

