/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.targeters.ConeTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LineTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingEntitiesInConeTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.LivingEntitiesInLineTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.MPEntity;
import io.lumine.xikage.mythicmobs.skills.targeters.MPLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MPMeta;
import io.lumine.xikage.mythicmobs.skills.targeters.MTLivingEntitiesInRadius;
import io.lumine.xikage.mythicmobs.skills.targeters.MTLivingEntitiesInWorld;
import io.lumine.xikage.mythicmobs.skills.targeters.MTLivingEntitiesNearTargetLocations;
import io.lumine.xikage.mythicmobs.skills.targeters.MTLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MTMobsInRadius;
import io.lumine.xikage.mythicmobs.skills.targeters.MTMount;
import io.lumine.xikage.mythicmobs.skills.targeters.MTNearestPlayer;
import io.lumine.xikage.mythicmobs.skills.targeters.MTOrigin;
import io.lumine.xikage.mythicmobs.skills.targeters.MTOriginEntitiesNear;
import io.lumine.xikage.mythicmobs.skills.targeters.MTOriginMobsNear;
import io.lumine.xikage.mythicmobs.skills.targeters.MTOriginPlayersNear;
import io.lumine.xikage.mythicmobs.skills.targeters.MTParent;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayerLocationsInRadius;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayersInRadius;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayersInRing;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayersInWorld;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayersNearTargetLocations;
import io.lumine.xikage.mythicmobs.skills.targeters.MTPlayersOnServer;
import io.lumine.xikage.mythicmobs.skills.targeters.MTRandomLocationsNearTargetEntities;
import io.lumine.xikage.mythicmobs.skills.targeters.MTRandomThreatTarget;
import io.lumine.xikage.mythicmobs.skills.targeters.MTRing;
import io.lumine.xikage.mythicmobs.skills.targeters.MTSelf;
import io.lumine.xikage.mythicmobs.skills.targeters.MTSelfLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MTSpawners;
import io.lumine.xikage.mythicmobs.skills.targeters.MTTarget;
import io.lumine.xikage.mythicmobs.skills.targeters.MTTargetLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MTThreatTable;
import io.lumine.xikage.mythicmobs.skills.targeters.MTThreatTablePlayers;
import io.lumine.xikage.mythicmobs.skills.targeters.MTTrigger;
import io.lumine.xikage.mythicmobs.skills.targeters.MTVanilla;
import io.lumine.xikage.mythicmobs.skills.targeters.MTWolfOwner;
import io.lumine.xikage.mythicmobs.skills.targeters.OwnerTargeter;

public abstract class SkillTargeter {
    public SkillTargeter(MythicLineConfig mlc) {
    }

    public SkillTargeter() {
    }

    public static SkillTargeter getMythicTargeter(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        switch (search.toUpperCase()) {
            case "CONE": {
                return new ConeTargeter(mlc);
            }
            case "LINE": {
                return new LineTargeter(mlc);
            }
            case "LIVINGINCONE": 
            case "LIVINGENTITIESINCONE": 
            case "ENTITIESINCONE": 
            case "ALLINCONE": 
            case "EIC": {
                return new LivingEntitiesInConeTargeter(mlc);
            }
            case "LIVINGINLINE": 
            case "LIVINGENTITIESINLINE": 
            case "ENTITIESINLINE": 
            case "ALLINLINE": 
            case "EIL": {
                return new LivingEntitiesInLineTargeter(mlc);
            }
            case "LIVINGINRADIUS": 
            case "ENTITIESINRADIUS": 
            case "LIVINGENTITIESINRADIUS": 
            case "ALLINRADIUS": 
            case "EIR": {
                return new MTLivingEntitiesInRadius(mlc);
            }
            case "LIVINGINWORLD": 
            case "ENTITIESINWORLD": 
            case "LIVINGENTITIESINWORLD": 
            case "ALLINWORLD": 
            case "EIW": {
                return new MTLivingEntitiesInWorld(mlc);
            }
            case "LIVINGNEARTARGETLOCATION": 
            case "LNTL": 
            case "LIVINGENTITIESNEARTARGETLOCATION": {
                return new MTLivingEntitiesNearTargetLocations(mlc);
            }
            case "LOCATION": 
            case "LOC": 
            case "L": {
                return new MTLocation(mlc);
            }
            case "MOBSINRADIUS": 
            case "MOBS": 
            case "MIR": {
                return new MTMobsInRadius(mlc);
            }
            case "MOUNT": {
                return new MTMount(mlc);
            }
            case "NEARESTPLAYER": {
                return new MTNearestPlayer(mlc);
            }
            case "OWNER": {
                return new OwnerTargeter(mlc);
            }
            case "PARENT": 
            case "SUMMONER": {
                return new MTParent(mlc);
            }
            case "PLAYERSINRADIUS": 
            case "RADIUS": 
            case "PIR": {
                return new MTPlayersInRadius(mlc);
            }
            case "PLAYERSNEARTARGETLOCATION": 
            case "PNTL": {
                return new MTPlayersNearTargetLocations(mlc);
            }
            case "PLAYERLOCATIONSSINRADIUS": 
            case "LOCATIONRADIUS": 
            case "PLR": 
            case "PLIR": {
                return new MTPlayerLocationsInRadius(mlc);
            }
            case "PLAYERSINRING": 
            case "PRING": {
                return new MTPlayersInRing(mlc);
            }
            case "PLAYERSINWORLD": 
            case "WORLD": {
                return new MTPlayersInWorld(mlc);
            }
            case "PLAYERSONSERVER": 
            case "SERVER": {
                return new MTPlayersOnServer(mlc);
            }
            case "RING": {
                return new MTRing(mlc);
            }
            case "RANDOMLOCATIONSNEARTARGETENTITIES": 
            case "RLNTE": {
                return new MTRandomLocationsNearTargetEntities(mlc);
            }
            case "SPAWNER": 
            case "SPAWNERS": {
                return new MTSpawners(mlc);
            }
            case "TARGET": 
            case "T": {
                return new MTTarget(mlc);
            }
            case "TARGETLOCATION": 
            case "TARGETLOC": 
            case "TL": {
                return new MTTargetLocation(mlc);
            }
            case "THREATTABLE": 
            case "THREATTARGETS": 
            case "TT": {
                return new MTThreatTable(mlc);
            }
            case "THREATTABLEPLAYERS": 
            case "PLAYERSINTHREATTABLE": 
            case "TTP": {
                return new MTThreatTablePlayers(mlc);
            }
            case "THREATTABLERANDOMTARGET": 
            case "RANDOMTHREATTARGET": 
            case "RTT": {
                return new MTRandomThreatTarget(mlc);
            }
            case "SELF": 
            case "BOSS": {
                return new MTSelf(mlc);
            }
            case "SELFLOCATION": 
            case "BOSSLOCATION": 
            case "MOBLOCATION": {
                return new MTSelfLocation(mlc);
            }
            case "TRIGGER": {
                return new MTTrigger(mlc);
            }
            case "ORIGIN": 
            case "SOURCE": {
                return new MTOrigin(mlc);
            }
            case "PLAYERSNEARORIGIN": 
            case "PLAYERSNEARSOURCE": {
                return new MTOriginPlayersNear(mlc);
            }
            case "ENTITIESNEARORIGIN": 
            case "ENTITIESNEARSOURCE": 
            case "ENO": 
            case "NEARORIGIN": {
                return new MTOriginEntitiesNear(mlc);
            }
            case "MOBSNEARORIGIN": 
            case "MOBSNEARSOURCE": {
                return new MTOriginMobsNear(mlc);
            }
            case "WOLFOWNER": {
                return new MTWolfOwner(mlc);
            }
            case "PARENTENTITIES": 
            case "PE": {
                return new MPEntity(mlc);
            }
            case "PARENTLOCATIONS": 
            case "PL": {
                return new MPLocation(mlc);
            }
            case "PARENTMETA": 
            case "PM": {
                return new MPMeta(mlc);
            }
            case "CONSOLE": 
            case "NONE": {
                return new ConsoleTargeter();
            }
        }
        switch (search.substring(0, 1).toLowerCase()) {
            case "p": 
            case "r": 
            case "a": 
            case "e": {
                return new MTVanilla(mlc, mlc.getLine());
            }
        }
        return new CustomTargeter(search.toUpperCase(), mlc);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

