/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.HashSet;

public class SkillMetadata
implements Cloneable {
    private final SkillTrigger cause;
    private IParentSkill caller = null;
    private SkillCaster caster;
    private AbstractEntity trigger;
    private AbstractLocation origin;
    private HashSet<AbstractEntity> eTargets;
    private HashSet<AbstractLocation> lTargets;
    private float power;
    private boolean async = true;

    public SkillMetadata(SkillTrigger cause, SkillCaster am, AbstractEntity trigger) {
        this.cause = cause;
        this.caster = am;
        this.trigger = trigger;
    }

    public SkillMetadata(SkillTrigger cause, SkillCaster am, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        this.cause = cause;
        this.caster = am;
        this.trigger = trigger;
        this.origin = origin;
        this.eTargets = eTargets;
        this.lTargets = lTargets;
        this.power = power;
    }

    public SkillMetadata(SkillMetadata source) {
        this.cause = source.getCause();
        this.caster = source.getCaster();
        this.trigger = source.getTrigger();
        this.origin = source.getOrigin();
        this.eTargets = source.getEntityTargets();
        this.lTargets = source.getLocationTargets();
        this.power = source.getPower();
    }

    public SkillTrigger getCause() {
        return this.cause;
    }

    public SkillCaster getCaster() {
        return this.caster;
    }

    public AbstractEntity getTrigger() {
        return this.trigger;
    }

    public AbstractLocation getOrigin() {
        return this.origin;
    }

    public SkillMetadata setOrigin(AbstractLocation o) {
        this.origin = o;
        return this;
    }

    public float getPower() {
        return this.power;
    }

    public SkillMetadata setPower(float p) {
        this.power = p;
        return this;
    }

    public boolean getIsAsync() {
        return this.async;
    }

    public SkillMetadata setIsAsync(boolean b) {
        this.async = b;
        return this;
    }

    public IParentSkill getCallingEvent() {
        return this.caller;
    }

    public void setCallingEvent(IParentSkill caller) {
        this.caller = caller;
    }

    public void cancelEvent() {
        if (this.caller != null) {
            this.caller.setCancelled();
        }
    }

    public HashSet<AbstractEntity> getEntityTargets() {
        return this.eTargets;
    }

    public SkillMetadata setEntityTargets(HashSet<AbstractEntity> targets) {
        if (this.lTargets != null) {
            this.lTargets = new HashSet();
        }
        this.eTargets = targets;
        return this;
    }

    public SkillMetadata setEntityTarget(AbstractEntity target) {
        if (this.lTargets != null) {
            this.lTargets = new HashSet();
        }
        this.eTargets = new HashSet();
        this.eTargets.add(target);
        return this;
    }

    public HashSet<AbstractLocation> getLocationTargets() {
        return this.lTargets;
    }

    public SkillMetadata setLocationTargets(HashSet<AbstractLocation> targets) {
        if (this.eTargets != null) {
            this.eTargets = new HashSet();
        }
        this.lTargets = targets;
        return this;
    }

    public SkillMetadata setLocationTarget(AbstractLocation target) {
        if (this.eTargets != null) {
            this.eTargets = new HashSet();
        }
        this.lTargets = new HashSet();
        this.lTargets.add(target);
        return this;
    }

    public SkillMetadata clone() throws CloneNotSupportedException {
        return (SkillMetadata)super.clone();
    }

    public SkillMetadata deepClone() {
        try {
            SkillMetadata clone = this.clone();
            clone.setCallingEvent(this.getCallingEvent());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCaster(SkillCaster caster) {
        this.caster = caster;
    }

    public void setTrigger(AbstractEntity entity) {
        this.trigger = entity;
    }
}

